/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class AddRaftVoterRequestData
implements ApiMessage {
    String clusterId;
    int timeoutMs;
    int voterId;
    Uuid voterDirectoryId;
    ListenerCollection listeners;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("cluster_id", Type.COMPACT_NULLABLE_STRING, ""), new Field("timeout_ms", Type.INT32, ""), new Field("voter_id", Type.INT32, "The replica id of the voter getting added to the topic partition"), new Field("voter_directory_id", Type.UUID, "The directory id of the voter getting added to the topic partition"), new Field("listeners", new CompactArrayOf(Listener.SCHEMA_0), "The endpoints that can be used to communicate with the voter"), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public AddRaftVoterRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public AddRaftVoterRequestData() {
        this.clusterId = "";
        this.timeoutMs = 0;
        this.voterId = 0;
        this.voterDirectoryId = Uuid.ZERO_UUID;
        this.listeners = new ListenerCollection(0);
    }

    @Override
    public short apiKey() {
        return 80;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.clusterId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clusterId had invalid length " + length);
            }
            this.clusterId = _readable.readString(length);
        }
        this.timeoutMs = _readable.readInt();
        this.voterId = _readable.readInt();
        this.voterDirectoryId = _readable.readUuid();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field listeners was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ListenerCollection newCollection = new ListenerCollection(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new Listener(_readable, _version));
        }
        this.listeners = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        if (this.clusterId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.clusterId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeInt(this.timeoutMs);
        _writable.writeInt(this.voterId);
        _writable.writeUuid(this.voterDirectoryId);
        _writable.writeUnsignedVarint(this.listeners.size() + 1);
        _stringBytes = this.listeners.iterator();
        while (_stringBytes.hasNext()) {
            Listener listenersElement = (Listener)_stringBytes.next();
            listenersElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (this.clusterId == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = this.clusterId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clusterId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.clusterId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(4);
        _size.addBytes(4);
        _size.addBytes(16);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.listeners.size() + 1));
        for (Listener listenersElement : this.listeners) {
            listenersElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddRaftVoterRequestData)) {
            return false;
        }
        AddRaftVoterRequestData other = (AddRaftVoterRequestData)obj;
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        if (this.voterId != other.voterId) {
            return false;
        }
        if (!this.voterDirectoryId.equals(other.voterDirectoryId)) {
            return false;
        }
        if (this.listeners == null ? other.listeners != null : !this.listeners.equals(other.listeners)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        hashCode = 31 * hashCode + this.timeoutMs;
        hashCode = 31 * hashCode + this.voterId;
        hashCode = 31 * hashCode + this.voterDirectoryId.hashCode();
        hashCode = 31 * hashCode + (this.listeners == null ? 0 : this.listeners.hashCode());
        return hashCode;
    }

    @Override
    public AddRaftVoterRequestData duplicate() {
        AddRaftVoterRequestData _duplicate = new AddRaftVoterRequestData();
        _duplicate.clusterId = this.clusterId == null ? null : this.clusterId;
        _duplicate.timeoutMs = this.timeoutMs;
        _duplicate.voterId = this.voterId;
        _duplicate.voterDirectoryId = this.voterDirectoryId;
        ListenerCollection newListeners = new ListenerCollection(this.listeners.size());
        for (Listener _element : this.listeners) {
            newListeners.add(_element.duplicate());
        }
        _duplicate.listeners = newListeners;
        return _duplicate;
    }

    public String toString() {
        return "AddRaftVoterRequestData(clusterId=" + (this.clusterId == null ? "null" : "'" + this.clusterId.toString() + "'") + ", timeoutMs=" + this.timeoutMs + ", voterId=" + this.voterId + ", voterDirectoryId=" + this.voterDirectoryId.toString() + ", listeners=" + MessageUtil.deepToString(this.listeners.iterator()) + ")";
    }

    public String clusterId() {
        return this.clusterId;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public int voterId() {
        return this.voterId;
    }

    public Uuid voterDirectoryId() {
        return this.voterDirectoryId;
    }

    public ListenerCollection listeners() {
        return this.listeners;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AddRaftVoterRequestData setClusterId(String v) {
        this.clusterId = v;
        return this;
    }

    public AddRaftVoterRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public AddRaftVoterRequestData setVoterId(int v) {
        this.voterId = v;
        return this;
    }

    public AddRaftVoterRequestData setVoterDirectoryId(Uuid v) {
        this.voterDirectoryId = v;
        return this;
    }

    public AddRaftVoterRequestData setListeners(ListenerCollection v) {
        this.listeners = v;
        return this;
    }

    public static class ListenerCollection
    extends ImplicitLinkedHashMultiCollection<Listener> {
        public ListenerCollection() {
        }

        public ListenerCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public ListenerCollection(Iterator<Listener> iterator2) {
            super(iterator2);
        }

        @Override
        public Listener find(String name2) {
            Listener _key = new Listener();
            _key.setName(name2);
            return this.find(_key);
        }

        @Override
        public List<Listener> findAll(String name2) {
            Listener _key = new Listener();
            _key.setName(name2);
            return this.findAll(_key);
        }

        public ListenerCollection duplicate() {
            ListenerCollection _duplicate = new ListenerCollection(this.size());
            for (Listener _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class Listener
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        String host;
        int port;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.COMPACT_STRING, "The name of the endpoint"), new Field("host", Type.COMPACT_STRING, "The hostname"), new Field("port", Type.UINT16, "The port"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Listener(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public Listener() {
            this.name = "";
            this.host = "";
            this.port = 0;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Listener");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.port = _readable.readUnsignedShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.host);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeUnsignedShort(this.port);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Listener");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.host, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof Listener)) {
                return false;
            }
            Listener other = (Listener)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Listener)) {
                return false;
            }
            Listener other = (Listener)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public Listener duplicate() {
            Listener _duplicate = new Listener();
            _duplicate.name = this.name;
            _duplicate.host = this.host;
            _duplicate.port = this.port;
            return _duplicate;
        }

        public String toString() {
            return "Listener(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", port=" + this.port + ")";
        }

        public String name() {
            return this.name;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Listener setName(String v) {
            this.name = v;
            return this;
        }

        public Listener setHost(String v) {
            this.host = v;
            return this;
        }

        public Listener setPort(int v) {
            if (v < 0 || v > 65535) {
                throw new RuntimeException("Invalid value " + v + " for unsigned short field.");
            }
            this.port = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }
    }
}

