/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ConsumerGroupState {
    UNKNOWN("Unknown"),
    PREPARING_REBALANCE("PreparingRebalance"),
    COMPLETING_REBALANCE("CompletingRebalance"),
    STABLE("Stable"),
    DEAD("Dead"),
    EMPTY("Empty"),
    ASSIGNING("Assigning"),
    RECONCILING("Reconciling");

    private static final Map<String, ConsumerGroupState> NAME_TO_ENUM;
    private final String name;

    private ConsumerGroupState(String name2) {
        this.name = name2;
    }

    public static ConsumerGroupState parse(String name2) {
        ConsumerGroupState state = NAME_TO_ENUM.get(name2.toUpperCase(Locale.ROOT));
        return state == null ? UNKNOWN : state;
    }

    public String toString() {
        return this.name;
    }

    static {
        NAME_TO_ENUM = Arrays.stream(ConsumerGroupState.values()).collect(Collectors.toMap(state -> state.name.toUpperCase(Locale.ROOT), Function.identity()));
    }
}

