/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.WindowedCount;

public class RebalanceMetricsManager {
    private final Sensor successfulRebalanceSensor;
    private final Sensor failedRebalanceSensor;
    private final String metricGroupName;
    public final MetricName rebalanceLatencyAvg;
    public final MetricName rebalanceLatencyMax;
    public final MetricName rebalanceLatencyTotal;
    public final MetricName rebalanceTotal;
    public final MetricName rebalanceRatePerHour;
    public final MetricName lastRebalanceSecondsAgo;
    public final MetricName failedRebalanceTotal;
    public final MetricName failedRebalanceRate;
    private long lastRebalanceEndMs = -1L;
    private long lastRebalanceStartMs = -1L;

    public RebalanceMetricsManager(Metrics metrics) {
        this.metricGroupName = "consumer-coordinator-metrics";
        this.rebalanceLatencyAvg = this.createMetric(metrics, "rebalance-latency-avg", "The average time taken for a group to complete a rebalance");
        this.rebalanceLatencyMax = this.createMetric(metrics, "rebalance-latency-max", "The max time taken for a group to complete a rebalance");
        this.rebalanceLatencyTotal = this.createMetric(metrics, "rebalance-latency-total", "The total number of milliseconds spent in rebalances");
        this.rebalanceTotal = this.createMetric(metrics, "rebalance-total", "The total number of rebalance events");
        this.rebalanceRatePerHour = this.createMetric(metrics, "rebalance-rate-per-hour", "The number of rebalance events per hour");
        this.failedRebalanceTotal = this.createMetric(metrics, "failed-rebalance-total", "The total number of failed rebalance events");
        this.failedRebalanceRate = this.createMetric(metrics, "failed-rebalance-rate-per-hour", "The number of failed rebalance events per hour");
        this.successfulRebalanceSensor = metrics.sensor("rebalance-latency");
        this.successfulRebalanceSensor.add(this.rebalanceLatencyAvg, new Avg());
        this.successfulRebalanceSensor.add(this.rebalanceLatencyMax, new Max());
        this.successfulRebalanceSensor.add(this.rebalanceLatencyTotal, new CumulativeSum());
        this.successfulRebalanceSensor.add(this.rebalanceTotal, new CumulativeCount());
        this.successfulRebalanceSensor.add(this.rebalanceRatePerHour, new Rate(TimeUnit.HOURS, new WindowedCount()));
        this.failedRebalanceSensor = metrics.sensor("failed-rebalance");
        this.failedRebalanceSensor.add(this.failedRebalanceTotal, new CumulativeSum());
        this.failedRebalanceSensor.add(this.failedRebalanceRate, new Rate(TimeUnit.HOURS, new WindowedCount()));
        Measurable lastRebalance = (config, now) -> {
            if (this.lastRebalanceEndMs == -1L) {
                return -1.0;
            }
            return TimeUnit.SECONDS.convert(now - this.lastRebalanceEndMs, TimeUnit.MILLISECONDS);
        };
        this.lastRebalanceSecondsAgo = this.createMetric(metrics, "last-rebalance-seconds-ago", "The number of seconds since the last rebalance event");
        metrics.addMetric(this.lastRebalanceSecondsAgo, lastRebalance);
    }

    private MetricName createMetric(Metrics metrics, String name2, String description) {
        return metrics.metricName(name2, this.metricGroupName, description);
    }

    public void recordRebalanceStarted(long nowMs) {
        this.lastRebalanceStartMs = nowMs;
    }

    public void recordRebalanceEnded(long nowMs) {
        this.lastRebalanceEndMs = nowMs;
        this.successfulRebalanceSensor.record(nowMs - this.lastRebalanceStartMs);
    }

    public void maybeRecordRebalanceFailed() {
        if (this.lastRebalanceStartMs <= this.lastRebalanceEndMs) {
            return;
        }
        this.failedRebalanceSensor.record();
    }

    public boolean rebalanceStarted() {
        return this.lastRebalanceStartMs > this.lastRebalanceEndMs;
    }
}

