/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.internals.AdminApiFuture;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.CoordinatorStrategy;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.DeleteGroupsRequestData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DeleteGroupsRequest;
import org.apache.kafka.common.requests.DeleteGroupsResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class DeleteConsumerGroupsHandler
extends AdminApiHandler.Batched<CoordinatorKey, Void> {
    private final Logger log;
    private final AdminApiLookupStrategy<CoordinatorKey> lookupStrategy;

    public DeleteConsumerGroupsHandler(LogContext logContext) {
        this.log = logContext.logger(DeleteConsumerGroupsHandler.class);
        this.lookupStrategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.GROUP, logContext);
    }

    @Override
    public String apiName() {
        return "deleteConsumerGroups";
    }

    @Override
    public AdminApiLookupStrategy<CoordinatorKey> lookupStrategy() {
        return this.lookupStrategy;
    }

    public static AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, Void> newFuture(Collection<String> groupIds) {
        return AdminApiFuture.forKeys(DeleteConsumerGroupsHandler.buildKeySet(groupIds));
    }

    private static Set<CoordinatorKey> buildKeySet(Collection<String> groupIds) {
        return groupIds.stream().map(CoordinatorKey::byGroupId).collect(Collectors.toSet());
    }

    public DeleteGroupsRequest.Builder buildBatchedRequest(int coordinatorId, Set<CoordinatorKey> keys2) {
        List<String> groupIds = keys2.stream().map(key -> key.idValue).collect(Collectors.toList());
        DeleteGroupsRequestData data = new DeleteGroupsRequestData().setGroupsNames(groupIds);
        return new DeleteGroupsRequest.Builder(data);
    }

    @Override
    public AdminApiHandler.ApiResult<CoordinatorKey, Void> handleResponse(Node coordinator, Set<CoordinatorKey> groupIds, AbstractResponse abstractResponse) {
        DeleteGroupsResponse response = (DeleteGroupsResponse)abstractResponse;
        HashMap<CoordinatorKey, Object> completed = new HashMap<CoordinatorKey, Object>();
        HashMap<CoordinatorKey, Throwable> failed = new HashMap<CoordinatorKey, Throwable>();
        HashSet<CoordinatorKey> groupsToUnmap = new HashSet<CoordinatorKey>();
        for (DeleteGroupsResponseData.DeletableGroupResult deletedGroup : response.data().results()) {
            CoordinatorKey groupIdKey = CoordinatorKey.byGroupId(deletedGroup.groupId());
            Errors error = Errors.forCode(deletedGroup.errorCode());
            if (error != Errors.NONE) {
                this.handleError(groupIdKey, error, failed, groupsToUnmap);
                continue;
            }
            completed.put(groupIdKey, null);
        }
        return new AdminApiHandler.ApiResult<CoordinatorKey, Void>(completed, failed, new ArrayList(groupsToUnmap));
    }

    private void handleError(CoordinatorKey groupId, Errors error, Map<CoordinatorKey, Throwable> failed, Set<CoordinatorKey> groupsToUnmap) {
        switch (error) {
            case GROUP_AUTHORIZATION_FAILED: 
            case INVALID_GROUP_ID: 
            case NON_EMPTY_GROUP: 
            case GROUP_ID_NOT_FOUND: {
                this.log.debug("`DeleteConsumerGroups` request for group id {} failed due to error {}", (Object)groupId.idValue, (Object)error);
                failed.put(groupId, error.exception());
                break;
            }
            case COORDINATOR_LOAD_IN_PROGRESS: {
                this.log.debug("`DeleteConsumerGroups` request for group id {} failed because the coordinator is still in the process of loading state. Will retry", (Object)groupId.idValue);
                break;
            }
            case COORDINATOR_NOT_AVAILABLE: 
            case NOT_COORDINATOR: {
                this.log.debug("`DeleteConsumerGroups` request for group id {} returned error {}. Will attempt to find the coordinator again and retry", (Object)groupId.idValue, (Object)error);
                groupsToUnmap.add(groupId);
                break;
            }
            default: {
                this.log.error("`DeleteConsumerGroups` request for group id {} failed due to unexpected error {}", (Object)groupId.idValue, (Object)error);
                failed.put(groupId, error.exception());
            }
        }
    }
}

