/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import java.util.HashMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;

public class SetPropertiesRule
extends Rule {
    private String[] attributeNames;
    private String[] propertyNames;
    private boolean ignoreMissingProperty = true;

    @Deprecated
    public SetPropertiesRule(Digester digester) {
        this();
    }

    public SetPropertiesRule() {
    }

    public SetPropertiesRule(String attributeName, String propertyName) {
        this.attributeNames = new String[1];
        this.attributeNames[0] = attributeName;
        this.propertyNames = new String[1];
        this.propertyNames[0] = propertyName;
    }

    public SetPropertiesRule(String[] attributeNames, String[] propertyNames) {
        this.attributeNames = new String[attributeNames.length];
        for (String this.attributeNames[i] : attributeNames) {
        }
        this.propertyNames = new String[propertyNames.length];
        for (String this.propertyNames[i] : propertyNames) {
        }
    }

    public void begin(Attributes attributes) throws Exception {
        HashMap<String, String> values2 = new HashMap<String, String>();
        int attNamesLength = 0;
        if (this.attributeNames != null) {
            attNamesLength = this.attributeNames.length;
        }
        int propNamesLength = 0;
        if (this.propertyNames != null) {
            propNamesLength = this.propertyNames.length;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            Object top;
            boolean test;
            String name2 = attributes.getLocalName(i);
            if ("".equals(name2)) {
                name2 = attributes.getQName(i);
            }
            String value = attributes.getValue(i);
            for (int n = 0; n < attNamesLength; ++n) {
                if (!name2.equals(this.attributeNames[n])) continue;
                if (n < propNamesLength) {
                    name2 = this.propertyNames[n];
                    break;
                }
                name2 = null;
                break;
            }
            if (this.digester.log.isDebugEnabled()) {
                this.digester.log.debug("[SetPropertiesRule]{" + this.digester.match + "} Setting property '" + name2 + "' to '" + value + "'");
            }
            if (!this.ignoreMissingProperty && name2 != null && !(test = PropertyUtils.isWriteable((Object)(top = this.digester.peek()), (String)name2))) {
                throw new NoSuchMethodException("Property " + name2 + " can't be set");
            }
            if (name2 == null) continue;
            values2.put(name2, value);
        }
        Object top = this.digester.peek();
        if (this.digester.log.isDebugEnabled()) {
            if (top != null) {
                this.digester.log.debug("[SetPropertiesRule]{" + this.digester.match + "} Set " + top.getClass().getName() + " properties");
            } else {
                this.digester.log.debug("[SetPropertiesRule]{" + this.digester.match + "} Set NULL properties");
            }
        }
        BeanUtils.populate((Object)top, values2);
    }

    public void addAlias(String attributeName, String propertyName) {
        if (this.attributeNames == null) {
            this.attributeNames = new String[1];
            this.attributeNames[0] = attributeName;
            this.propertyNames = new String[1];
            this.propertyNames[0] = propertyName;
        } else {
            int length = this.attributeNames.length;
            String[] tempAttributes = new String[length + 1];
            for (int i = 0; i < length; ++i) {
                tempAttributes[i] = this.attributeNames[i];
            }
            tempAttributes[length] = attributeName;
            String[] tempProperties = new String[length + 1];
            for (int i = 0; i < length && i < this.propertyNames.length; ++i) {
                tempProperties[i] = this.propertyNames[i];
            }
            tempProperties[length] = propertyName;
            this.propertyNames = tempProperties;
            this.attributeNames = tempAttributes;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SetPropertiesRule[");
        sb.append("]");
        return sb.toString();
    }

    public boolean isIgnoreMissingProperty() {
        return this.ignoreMissingProperty;
    }

    public void setIgnoreMissingProperty(boolean ignoreMissingProperty) {
        this.ignoreMissingProperty = ignoreMissingProperty;
    }
}

