/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.util.Locale;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaFormatterCache;
import org.apache.avro.SchemaFormatterFactory;

public interface SchemaFormatter {
    public static SchemaFormatter getInstance(String name2) {
        int slashPos = name2.indexOf("/");
        String formatName = slashPos < 0 ? name2 : name2.substring(0, slashPos);
        String variantName = slashPos < 0 ? null : name2.substring(slashPos + 1).toLowerCase(Locale.ROOT);
        for (SchemaFormatterFactory formatterFactory : SchemaFormatterCache.LOADER) {
            if (!formatName.equalsIgnoreCase(formatterFactory.formatName())) continue;
            if (variantName == null) {
                return formatterFactory.getDefaultFormatter();
            }
            return formatterFactory.getFormatterForVariant(variantName);
        }
        throw new AvroRuntimeException("Unsupported schema format: " + name2 + "; see the javadoc for valid examples");
    }

    public static String format(String name2, Schema schema) {
        return SchemaFormatter.getInstance(name2).format(schema);
    }

    public String format(Schema var1);
}

