/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.util.MapEntry;
import org.apache.avro.util.internal.Accessor;
import org.apache.avro.util.internal.JacksonUtils;

public abstract class JsonProperties {
    public static final Null NULL_VALUE;
    private ConcurrentMap<String, JsonNode> props = new ConcurrentHashMap<String, JsonNode>(){
        private static final long serialVersionUID = 1L;
        private Queue<MapEntry<String, JsonNode>> propOrder = new ConcurrentLinkedQueue<MapEntry<String, JsonNode>>();

        @Override
        public JsonNode putIfAbsent(String key, JsonNode value) {
            JsonNode r = super.putIfAbsent(key, value);
            if (r == null) {
                this.propOrder.add(new MapEntry<String, JsonNode>(key, value));
            }
            return r;
        }

        @Override
        public JsonNode put(String key, JsonNode value) {
            return this.putIfAbsent(key, value);
        }

        @Override
        public Set<Map.Entry<String, JsonNode>> entrySet() {
            return new AbstractSet<Map.Entry<String, JsonNode>>(){

                @Override
                public Iterator<Map.Entry<String, JsonNode>> iterator() {
                    return new Iterator<Map.Entry<String, JsonNode>>(){
                        Iterator<MapEntry<String, JsonNode>> it;
                        {
                            this.it = propOrder.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.it.hasNext();
                        }

                        @Override
                        public Map.Entry<String, JsonNode> next() {
                            return this.it.next();
                        }
                    };
                }

                @Override
                public int size() {
                    return propOrder.size();
                }
            };
        }
    };
    private Set<String> reserved;

    JsonProperties(Set<String> reserved) {
        this.reserved = reserved;
    }

    JsonProperties(Set<String> reserved, Map<String, ?> propMap) {
        this.reserved = reserved;
        for (Map.Entry<String, ?> a : propMap.entrySet()) {
            Object v = a.getValue();
            JsonNode json = null;
            json = v instanceof String ? TextNode.valueOf((String)v) : (v instanceof JsonNode ? (JsonNode)v : JacksonUtils.toJsonNode(v));
            this.props.put(a.getKey(), json);
        }
    }

    public String getProp(String name2) {
        JsonNode value = this.getJsonProp(name2);
        return value != null && value.isTextual() ? value.textValue() : null;
    }

    private JsonNode getJsonProp(String name2) {
        return (JsonNode)this.props.get(name2);
    }

    public Object getObjectProp(String name2) {
        return JacksonUtils.toObject((JsonNode)this.props.get(name2));
    }

    public Object getObjectProp(String name2, Object defaultValue) {
        JsonNode json = (JsonNode)this.props.get(name2);
        return json != null ? JacksonUtils.toObject(json) : defaultValue;
    }

    public void addProp(String name2, String value) {
        this.addProp(name2, TextNode.valueOf(value));
    }

    public void addProp(String name2, Object value) {
        if (value instanceof JsonNode) {
            this.addProp(name2, (JsonNode)value);
        } else {
            this.addProp(name2, JacksonUtils.toJsonNode(value));
        }
    }

    public void putAll(JsonProperties np) {
        for (Map.Entry e : np.props.entrySet()) {
            this.addProp((String)e.getKey(), (JsonNode)e.getValue());
        }
    }

    private void addProp(String name2, JsonNode value) {
        if (this.reserved.contains(name2)) {
            throw new AvroRuntimeException("Can't set reserved property: " + name2);
        }
        if (value == null) {
            throw new AvroRuntimeException("Can't set a property to null: " + name2);
        }
        JsonNode old = this.props.putIfAbsent(name2, value);
        if (old != null && !old.equals(value)) {
            throw new AvroRuntimeException("Can't overwrite property: " + name2);
        }
    }

    public void addAllProps(JsonProperties properties) {
        for (Map.Entry entry : properties.props.entrySet()) {
            this.addProp((String)entry.getKey(), (JsonNode)entry.getValue());
        }
    }

    public Map<String, Object> getObjectProps() {
        LinkedHashMap<String, Object> result2 = new LinkedHashMap<String, Object>();
        for (Map.Entry e : this.props.entrySet()) {
            result2.put((String)e.getKey(), JacksonUtils.toObject((JsonNode)e.getValue()));
        }
        return Collections.unmodifiableMap(result2);
    }

    public boolean propsContainsKey(String key) {
        return this.props.containsKey(key);
    }

    public void forEachProperty(BiConsumer<String, Object> consumer) {
        for (Map.Entry entry : this.props.entrySet()) {
            Object value = JacksonUtils.toObject((JsonNode)entry.getValue());
            consumer.accept((String)entry.getKey(), value);
        }
    }

    void writeProps(JsonGenerator gen) throws IOException {
        for (Map.Entry e : this.props.entrySet()) {
            gen.writeObjectField((String)e.getKey(), e.getValue());
        }
    }

    int propsHashCode() {
        return this.props.hashCode();
    }

    boolean propsEqual(JsonProperties np) {
        return Objects.equals(this.props, np.props);
    }

    public boolean hasProps() {
        return !this.props.isEmpty();
    }

    static {
        Accessor.setAccessor(new Accessor.JsonPropertiesAccessor(){

            @Override
            protected void addProp(JsonProperties props, String name2, JsonNode value) {
                props.addProp(name2, value);
            }
        });
        NULL_VALUE = new Null();
    }

    public static class Null {
        private Null() {
        }
    }
}

