/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classpath;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandlerRegistry;
import nonapi.io.github.classgraph.utils.LogNode;

public class ClassLoaderOrder {
    private final List<Map.Entry<ClassLoader, ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry>> classLoaderOrder = new ArrayList<Map.Entry<ClassLoader, ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry>>();
    private final Set<ClassLoader> added = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<ClassLoader> delegatedTo = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<ClassLoader> allParentClassLoaders = Collections.newSetFromMap(new IdentityHashMap());
    private final Map<ClassLoader, ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> classLoaderToClassLoaderHandlerRegistryEntry = new IdentityHashMap<ClassLoader, ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry>();

    public List<Map.Entry<ClassLoader, ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry>> getClassLoaderOrder() {
        return this.classLoaderOrder;
    }

    public Set<ClassLoader> getAllParentClassLoaders() {
        return this.allParentClassLoaders;
    }

    private ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry getRegistryEntry(ClassLoader classLoader2, LogNode log) {
        ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry entry = this.classLoaderToClassLoaderHandlerRegistryEntry.get(classLoader2);
        if (entry == null) {
            for (Class<?> currClassLoaderClass = classLoader2.getClass(); currClassLoaderClass != Object.class && currClassLoaderClass != null; currClassLoaderClass = currClassLoaderClass.getSuperclass()) {
                for (ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry ent : ClassLoaderHandlerRegistry.CLASS_LOADER_HANDLERS) {
                    if (!ent.canHandle(currClassLoaderClass, log)) continue;
                    entry = ent;
                    break;
                }
                if (entry != null) break;
            }
            if (entry == null) {
                entry = ClassLoaderHandlerRegistry.FALLBACK_HANDLER;
            }
            this.classLoaderToClassLoaderHandlerRegistryEntry.put(classLoader2, entry);
        }
        return entry;
    }

    public void add(ClassLoader classLoader2, LogNode log) {
        ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry entry;
        if (classLoader2 == null) {
            return;
        }
        if (this.added.add(classLoader2) && (entry = this.getRegistryEntry(classLoader2, log)) != null) {
            this.classLoaderOrder.add(new AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry>(classLoader2, entry));
        }
    }

    public void delegateTo(ClassLoader classLoader2, boolean isParent, LogNode log) {
        if (classLoader2 == null) {
            return;
        }
        if (isParent) {
            this.allParentClassLoaders.add(classLoader2);
        }
        if (this.delegatedTo.add(classLoader2)) {
            ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry entry = this.getRegistryEntry(classLoader2, log);
            entry.findClassLoaderOrder(classLoader2, this, log);
        }
    }
}

