/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal;

import com.networknt.client.Http2Client;
import com.networknt.client.simplepool.SimpleConnectionHolder;
import com.networknt.cluster.Cluster;
import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.server.ServerConfig;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.status.Status;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import net.lightapi.portal.PortalClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.OptionMap;

public class HybridQueryClient {
    static final Logger logger = LoggerFactory.getLogger(HybridQueryClient.class);
    static final String FAILED_TO_POPULATE_HEADER = "ERR12050";
    public static final PortalClientConfig config = (PortalClientConfig)Config.getInstance().getJsonObjectConfig("portal-client", PortalClientConfig.class);
    static String tag = ServerConfig.getInstance().getEnvironment();
    static Cluster cluster = SingletonServiceFactory.getBean(Cluster.class);
    static Http2Client client = Http2Client.getInstance();
    static final String GENERIC_EXCEPTION = "ERR10014";
    static Map<String, ClientConnection> connCache = new ConcurrentHashMap<String, ClientConnection>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<String> callQueryWithToken(String command, String token) {
        Result<String> result2 = null;
        SimpleConnectionHolder.ConnectionToken connectionToken = null;
        try {
            String host = cluster.serviceToUrl("https", config.getPortalQueryServiceId(), tag, null);
            if (logger.isTraceEnabled()) {
                logger.trace("serviceId " + config.getPortalQueryServiceId() + " with result " + host);
            }
            URI uri = new URI(host);
            connectionToken = client.borrow(uri, Http2Client.WORKER, client.getDefaultXnioSsl(), Http2Client.BUFFER_POOL, OptionMap.create(UndertowOptions.ENABLE_HTTP2, true));
            ClientConnection connection = (ClientConnection)connectionToken.getRawConnection();
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
            String message = "/portal/query?cmd=" + URLEncoder.encode(command, StandardCharsets.UTF_8);
            ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(message);
            request.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + token);
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            connection.sendRequest(request, client.createClientCallback(reference, latch));
            latch.await();
            int statusCode = reference.get().getResponseCode();
            String body = reference.get().getAttachment(Http2Client.RESPONSE_BODY);
            if (statusCode != 200) {
                Status status = Config.getInstance().getMapper().readValue(body, Status.class);
                result2 = Failure.of(status);
            } else {
                result2 = Success.of(body);
            }
            client.restore(connectionToken);
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            Status status = new Status(GENERIC_EXCEPTION, e.getMessage());
            result2 = Failure.of(status);
        }
        finally {
            client.restore(connectionToken);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<String> callQueryExchangeUrl(String command, HttpServerExchange exchange, String url) {
        Result<String> result2 = null;
        SimpleConnectionHolder.ConnectionToken connectionToken = null;
        try {
            URI uri = new URI(url);
            connectionToken = client.borrow(uri, Http2Client.WORKER, client.getDefaultXnioSsl(), Http2Client.BUFFER_POOL, OptionMap.create(UndertowOptions.ENABLE_HTTP2, true));
            ClientConnection connection = (ClientConnection)connectionToken.getRawConnection();
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
            String message = "/portal/query?cmd=" + URLEncoder.encode(command, "UTF-8");
            ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(message);
            String token = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
            if (token != null) {
                request.getRequestHeaders().put(Headers.AUTHORIZATION, token);
            }
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            connection.sendRequest(request, client.createClientCallback(reference, latch));
            latch.await();
            int statusCode = reference.get().getResponseCode();
            String body = reference.get().getAttachment(Http2Client.RESPONSE_BODY);
            if (logger.isTraceEnabled()) {
                logger.trace("statusCode = " + statusCode + " body = " + body);
            }
            if (statusCode != 200) {
                Status status = Config.getInstance().getMapper().readValue(body, Status.class);
                result2 = Failure.of(status);
            } else {
                result2 = Success.of(body);
            }
            client.restore(connectionToken);
        }
        catch (Exception e) {
            try {
                logger.error("Exception:", e);
                Status status = new Status(GENERIC_EXCEPTION, e.getMessage());
                result2 = Failure.of(status);
                client.restore(connectionToken);
            }
            catch (Throwable throwable) {
                client.restore(connectionToken);
                throw throwable;
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<String> callQueryExchange(String command, HttpServerExchange exchange) {
        Result<String> result2 = null;
        SimpleConnectionHolder.ConnectionToken connectionToken = null;
        try {
            String host = cluster.serviceToUrl("https", config.getPortalQueryServiceId(), tag, null);
            if (logger.isTraceEnabled()) {
                logger.trace("serviceId " + config.getPortalQueryServiceId() + " with result " + host);
            }
            URI uri = new URI(host);
            connectionToken = client.borrow(uri, Http2Client.WORKER, client.getDefaultXnioSsl(), Http2Client.BUFFER_POOL, OptionMap.create(UndertowOptions.ENABLE_HTTP2, true));
            ClientConnection connection = (ClientConnection)connectionToken.getRawConnection();
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
            String message = "/portal/query?cmd=" + URLEncoder.encode(command, "UTF-8");
            ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(message);
            String token = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
            if (token != null) {
                request.getRequestHeaders().put(Headers.AUTHORIZATION, token);
            } else {
                request.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + config.getBootstrapToken());
            }
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            connection.sendRequest(request, client.createClientCallback(reference, latch));
            latch.await();
            int statusCode = reference.get().getResponseCode();
            String body = reference.get().getAttachment(Http2Client.RESPONSE_BODY);
            if (statusCode != 200) {
                Status status = Config.getInstance().getMapper().readValue(body, Status.class);
                result2 = Failure.of(status);
            } else {
                result2 = Success.of(body);
            }
            client.restore(connectionToken);
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            Status status = new Status(GENERIC_EXCEPTION, e.getMessage());
            result2 = Failure.of(status);
        }
        finally {
            client.restore(connectionToken);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<String> callQueryUrl(String command, String url) {
        Result<String> result2 = null;
        SimpleConnectionHolder.ConnectionToken connectionToken = null;
        try {
            URI uri = new URI(url);
            connectionToken = client.borrow(uri, Http2Client.WORKER, client.getDefaultXnioSsl(), Http2Client.BUFFER_POOL, OptionMap.create(UndertowOptions.ENABLE_HTTP2, true));
            ClientConnection connection = (ClientConnection)connectionToken.getRawConnection();
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
            String message = "/portal/query?cmd=" + URLEncoder.encode(command, "UTF-8");
            ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(message);
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            connection.sendRequest(request, client.createClientCallback(reference, latch));
            latch.await();
            int statusCode = reference.get().getResponseCode();
            String body = reference.get().getAttachment(Http2Client.RESPONSE_BODY);
            if (statusCode != 200) {
                Status status = Config.getInstance().getMapper().readValue(body, Status.class);
                result2 = Failure.of(status);
            } else {
                result2 = Success.of(body);
            }
            client.restore(connectionToken);
        }
        catch (Exception e) {
            try {
                logger.error("Exception:", e);
                Status status = new Status(GENERIC_EXCEPTION, e.getMessage());
                result2 = Failure.of(status);
                client.restore(connectionToken);
            }
            catch (Throwable throwable) {
                client.restore(connectionToken);
                throw throwable;
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<String> callQueryTokenUrl(String command, String token, String url) {
        Result<String> result2 = null;
        SimpleConnectionHolder.ConnectionToken connectionToken = null;
        try {
            URI uri = new URI(url);
            connectionToken = client.borrow(uri, Http2Client.WORKER, client.getDefaultXnioSsl(), Http2Client.BUFFER_POOL, OptionMap.create(UndertowOptions.ENABLE_HTTP2, true));
            ClientConnection connection = (ClientConnection)connectionToken.getRawConnection();
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
            String message = "/portal/query?cmd=" + URLEncoder.encode(command, "UTF-8");
            ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(message);
            request.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + token);
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            connection.sendRequest(request, client.createClientCallback(reference, latch));
            latch.await();
            int statusCode = reference.get().getResponseCode();
            String body = reference.get().getAttachment(Http2Client.RESPONSE_BODY);
            if (statusCode != 200) {
                Status status = Config.getInstance().getMapper().readValue(body, Status.class);
                result2 = Failure.of(status);
            } else {
                result2 = Success.of(body);
            }
            client.restore(connectionToken);
        }
        catch (Exception e) {
            try {
                logger.error("Exception:", e);
                Status status = new Status(GENERIC_EXCEPTION, e.getMessage());
                result2 = Failure.of(status);
                client.restore(connectionToken);
            }
            catch (Throwable throwable) {
                client.restore(connectionToken);
                throw throwable;
            }
        }
        return result2;
    }

    public static Result<String> getUserByEmail(HttpServerExchange exchange, String email) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"queryUserByEmail\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryExchangeUrl(command, exchange, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryExchange(command, exchange);
    }

    public static Result<String> getUserByEmail(HttpServerExchange exchange, String url, String email) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"queryUserByEmail\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getUserByEmail(String email, String token) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"queryUserByEmail\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryTokenUrl(command, token, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryWithToken(command, token);
    }

    public static Result<String> getUserById(HttpServerExchange exchange, String userId) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"queryUserById\",\"version\":\"0.1.0\",\"data\":{\"userId\":\"%s\"}}", userId);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryExchangeUrl(command, exchange, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryExchange(command, exchange);
    }

    public static Result<String> getUserById(HttpServerExchange exchange, String url, String userId) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"queryUserById\",\"version\":\"0.1.0\",\"data\":{\"userId\":\"%s\"}}", userId);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getUserById(String userId, String token) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"queryUserById\",\"version\":\"0.1.0\",\"data\":{\"userId\":\"%s\"}}", userId);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryTokenUrl(command, token, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryWithToken(command, token);
    }

    public static Result<String> getUserByTypeEntityId(HttpServerExchange exchange, String userType, String entityId) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"queryUserByTypeEntityId\",\"version\":\"0.1.0\",\"data\":{\"userType\":\"%s\",\"entityId\":\"%s\"}}", userType, entityId);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryExchangeUrl(command, exchange, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryExchange(command, exchange);
    }

    public static Result<String> getUserByTypeEntityId(HttpServerExchange exchange, String url, String userType, String entityId) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"queryUserByTypeEntityId\",\"version\":\"0.1.0\",\"data\":{\"userType\":\"%s\",\"entityId\":\"%s\"}}", userType, entityId);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getUserByTypeEntityId(String userType, String entityId, String token) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"queryUserByTypeEntityId\",\"version\":\"0.1.0\",\"data\":{\"userType\":\"%s\",\"entityId\":\"%s\"}}", userType, entityId);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryTokenUrl(command, token, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryWithToken(command, token);
    }

    public static Result<String> getNonceByUserId(HttpServerExchange exchange, String userId) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"getNonceByUserId\",\"version\":\"0.1.0\",\"data\":{\"userId\":\"%s\"}}", userId);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryExchangeUrl(command, exchange, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryExchange(command, exchange);
    }

    public static Result<String> getNonceByUserId(HttpServerExchange exchange, String url, String userId) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"getNonceByUserId\",\"version\":\"0.1.0\",\"data\":{\"userId\":\"%s\"}}", userId);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getCity(HttpServerExchange exchange, String country, String province, String city) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"covid\",\"action\":\"getCity\",\"version\":\"0.1.0\",\"data\":{\"country\":\"%s\",\"province\":\"%s\",\"city\":\"%s\"}}", country, province, city);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryExchangeUrl(command, exchange, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryExchange(command, exchange);
    }

    public static Result<String> loginUser(String url, String email, String password) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"loginUser\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\",\"password\":\"%s\"}}", email, password);
        return HybridQueryClient.callQueryUrl(command, url);
    }

    public static Result<String> getMessageByEmail(HttpServerExchange exchange, String url, String email) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"getPrivateMessage\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getNotificationByEmail(HttpServerExchange exchange, String url, String email) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"getNotification\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getEntity(HttpServerExchange exchange, String url, String email) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"covid\",\"action\":\"getEntity\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getStatusByEmail(HttpServerExchange exchange, String url, String email) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"covid\",\"action\":\"getStatusByEmail\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getStatusByEmail(String url, String email, String token) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"covid\",\"action\":\"getStatusByEmail\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryTokenUrl(command, token, url);
    }

    public static Result<String> getWebsiteByEmail(HttpServerExchange exchange, String url, String email) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"covid\",\"action\":\"getWebsiteByEmail\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getWebsiteByEmail(String url, String email, String token) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"covid\",\"action\":\"getWebsiteByEmail\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryTokenUrl(command, token, url);
    }

    public static Result<String> getPaymentByEmail(HttpServerExchange exchange, String url, String email) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"getPayment\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getPaymentByEmail(String url, String email, String token) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"getPayment\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryTokenUrl(command, token, url);
    }

    public static Result<String> getCustomerOrderByEmail(HttpServerExchange exchange, String url, String email, int offset, int limit) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"getCustomerOrder\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\",\"offset\":%d,\"limit\":%d}}", email, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getMerchantOrderByEmail(HttpServerExchange exchange, String url, String email, String orderStatus, int offset, int limit) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"getMerchantOrder\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\",\"status\":\"%s\",\"offset\":%d,\"limit\":%d}}", email, orderStatus, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getClientById(HttpServerExchange exchange, String url, String clientId) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"oauth\",\"action\":\"getClientById\",\"version\":\"0.1.0\",\"data\":{\"clientId\":\"%s\"}}", clientId);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getClientById(String token, String url, String clientId) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"oauth\",\"action\":\"getClientById\",\"version\":\"0.1.0\",\"data\":{\"clientId\":\"%s\"}}", clientId);
        return HybridQueryClient.callQueryTokenUrl(s2, token, url);
    }

    public static Result<String> getClientById(String token, String clientId) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"oauth\",\"action\":\"getClientById\",\"version\":\"0.1.0\",\"data\":{\"clientId\":\"%s\"}}", clientId);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryTokenUrl(s2, token, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryWithToken(s2, token);
    }

    public static Result<String> getClientByProviderClientId(String token, String providerId, String clientId) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"oauth\",\"action\":\"getClientByProviderClientId\",\"version\":\"0.1.0\",\"data\":{\"providerId\":\"%s\",\"clientId\":\"%s\"}}", providerId, clientId);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryTokenUrl(s2, token, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryWithToken(s2, token);
    }

    public static Result<String> getClient(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"client\",\"action\":\"getClient\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getService(HttpServerExchange exchange, String url, String host, String style, int offset, int limit) {
        String s2 = style != null ? String.format("{\"host\":\"lightapi.net\",\"service\":\"service\",\"action\":\"getService\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"style\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, style, offset, limit) : String.format("{\"host\":\"lightapi.net\",\"service\":\"service\",\"action\":\"getService\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getServiceById(HttpServerExchange exchange, String url, String serviceId) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"service\",\"action\":\"getServiceById\",\"version\":\"0.1.0\",\"data\":{\"serviceId\":\"%s\"}}", serviceId);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getServiceRoleById(HttpServerExchange exchange, String url, String serviceId) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"service\",\"action\":\"getServiceRoleById\",\"version\":\"0.1.0\",\"data\":{\"serviceId\":\"%s\"}}", serviceId);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getRefreshTokenDetail(HttpServerExchange exchange, String url, String refreshToken) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"oauth\",\"action\":\"getRefreshTokenDetail\",\"version\":\"0.1.0\",\"data\":{\"refreshToken\":\"%s\"}}", refreshToken);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getRefreshToken(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"oauth\",\"action\":\"getRefreshToken\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getAuthCodeDetail(HttpServerExchange exchange, String url, String hostId, String authCode, boolean derived) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"oauth\",\"action\":\"getAuthCodeDetail\",\"version\":\"0.1.0\",\"data\":{\"hostId\":\"%s\",\"authCode\":\"%s\",\"derived\":%b}}", hostId, authCode, derived);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getAuthCodeDetail(String authCode, String token, boolean derive) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"oauth\",\"action\":\"getAuthCodeDetail\",\"version\":\"0.1.0\",\"data\":{\"authCode\":\"%s\",\"derived\":%b}}", authCode, derive);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryTokenUrl(s2, token, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryWithToken(s2, token);
    }

    public static Result<String> getAuthCode(HttpServerExchange exchange, String host, int offset, int limit) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"oauth\",\"action\":\"getAuthCode\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryExchangeUrl(s2, exchange, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryExchange(s2, exchange);
    }

    public static Result<String> getAuthCode(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"oauth\",\"action\":\"getAuthCode\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getRefTokenDetail(HttpServerExchange exchange, String url, String refToken) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"oauth\",\"action\":\"getRefTokenDetail\",\"version\":\"0.1.0\",\"data\":{\"refToken\":\"%s\"}}", refToken);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getRefTokenDetail(String refToken, String token) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"oauth\",\"action\":\"getRefTokenDetail\",\"version\":\"0.1.0\",\"data\":{\"refToken\":\"%s\"}}", refToken);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryTokenUrl(s2, token, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryWithToken(s2, token);
    }

    public static Result<String> getRefToken(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"oauth\",\"action\":\"getRefToken\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getProviderDetail(HttpServerExchange exchange, String url, String providerId) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"oauth\",\"action\":\"getProviderDetail\",\"version\":\"0.1.0\",\"data\":{\"providerId\":\"%s\"}}", providerId);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getProvider(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"oauth\",\"action\":\"getProvider\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getProviderKey(HttpServerExchange exchange, String hostId, String providerId) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"oauth\",\"action\":\"getProviderKey\",\"version\":\"0.1.0\",\"data\":{\"hostId\":\"%s\",\"providerId\":\"%s\"}}", hostId, providerId);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryExchangeUrl(s2, exchange, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryExchange(s2, exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<String> getHosts() {
        String path = "/r/data?name=host";
        Result<String> result2 = null;
        SimpleConnectionHolder.ConnectionToken connectionToken = null;
        try {
            String host = cluster.serviceToUrl("https", config.getPortalReferenceServiceId(), tag, null);
            URI uri = new URI(host);
            connectionToken = client.borrow(uri, Http2Client.WORKER, client.getDefaultXnioSsl(), Http2Client.BUFFER_POOL, OptionMap.create(UndertowOptions.ENABLE_HTTP2, true));
            ClientConnection connection = (ClientConnection)connectionToken.getRawConnection();
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
            ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(path);
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            connection.sendRequest(request, client.createClientCallback(reference, latch));
            latch.await();
            int statusCode = reference.get().getResponseCode();
            String body = reference.get().getAttachment(Http2Client.RESPONSE_BODY);
            if (statusCode != 200) {
                Status status = Config.getInstance().getMapper().readValue(body, Status.class);
                result2 = Failure.of(status);
            } else {
                result2 = Success.of(body);
            }
            client.restore(connectionToken);
        }
        catch (Exception e) {
            try {
                logger.error("Exception:", e);
                Status status = new Status(GENERIC_EXCEPTION, e.getMessage());
                result2 = Failure.of(status);
                client.restore(connectionToken);
            }
            catch (Throwable throwable) {
                client.restore(connectionToken);
                throw throwable;
            }
        }
        return result2;
    }

    public static Result<String> getHost(HttpServerExchange exchange, String url, String host) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"host\",\"action\":\"getHost\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\"}}", host);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getHost(HttpServerExchange exchange, String host) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"host\",\"action\":\"getHost\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\"}}", host);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryExchangeUrl(s2, exchange, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryExchange(s2, exchange);
    }

    public static Result<String> getHostDomainById(HttpServerExchange exchange, String url, String hostId) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"host\",\"action\":\"getHostDomainById\",\"version\":\"0.1.0\",\"data\":{\"hostId\":\"%s\"}}", hostId);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getHostDomainById(HttpServerExchange exchange, String hostId) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"host\",\"action\":\"getHostDomainById\",\"version\":\"0.1.0\",\"data\":{\"hostId\":\"%s\"}}", hostId);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryExchangeUrl(s2, exchange, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryExchange(s2, exchange);
    }

    public static Result<String> getCategoryByName(HttpServerExchange exchange, String url, String host, String name2) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"category\",\"action\":\"getCategoryByName\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"name\":\"%s\"}}", host, name2);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getCategory(HttpServerExchange exchange, String url, String host) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"category\",\"action\":\"getCategory\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\"}}", host);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getBlogById(HttpServerExchange exchange, String url, String host, String id) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"blog\",\"action\":\"getBlogById\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"id\":\"%s\"}}", host, id);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getBlogById(HttpServerExchange exchange, String host, String id) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"blog\",\"action\":\"getBlogById\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"id\":\"%s\"}}", host, id);
        return HybridQueryClient.callQueryExchange(s2, exchange);
    }

    public static Result<String> getBlogList(HttpServerExchange exchange, String url, String host, int offset, int limit, List<String> categories, List<String> tags) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("host", "lightapi.net");
        map.put("service", "blog");
        map.put("action", "getBlogList");
        map.put("version", "0.1.0");
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("host", host);
        dataMap.put("offset", offset);
        dataMap.put("limit", limit);
        dataMap.put("categories", categories);
        dataMap.put("tags", tags);
        map.put("data", dataMap);
        return HybridQueryClient.callQueryExchangeUrl(JsonMapper.toJson(map), exchange, url);
    }

    public static Result<String> getBlog(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"blog\",\"action\":\"getBlog\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getDocumentById(HttpServerExchange exchange, String url, String host, String id) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"document\",\"action\":\"getDocumentById\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"id\":\"%s\"}}", host, id);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getDocument(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"document\",\"action\":\"getDocument\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getNewsById(HttpServerExchange exchange, String url, String host, String id) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"news\",\"action\":\"getNewsById\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"id\":\"%s\"}}", host, id);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getNews(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"news\",\"action\":\"getNews\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getPageById(HttpServerExchange exchange, String url, String host, String id) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"page\",\"action\":\"getPageById\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"id\":\"%s\"}}", host, id);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getPage(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"page\",\"action\":\"getPage\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getTemplateById(HttpServerExchange exchange, String url, String host, String id) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"template\",\"action\":\"getTemplateById\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"id\":\"%s\"}}", host, id);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getTemplate(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"template\",\"action\":\"getTemplate\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getTags(String url, String host, String app) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"tag\",\"action\":\"getTags\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"app\":\"%s\",\"local\":true}}", host, app);
        return HybridQueryClient.callQueryUrl(s2, url);
    }

    public static Result<String> getError(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"error\",\"action\":\"getError\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getErrorByCode(HttpServerExchange exchange, String url, String host, String errorCode) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"error\",\"action\":\"getErrorByCode\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"errorCode\":\"%s\"}}", host, errorCode);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getJsonSchema(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"schema\",\"action\":\"getJsonSchema\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getJsonSchemaById(HttpServerExchange exchange, String url, String host, String id) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"schema\",\"action\":\"getJsonSchemaById\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"id\":\"%s\"}}", host, id);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getJsonSchemaById(HttpServerExchange exchange, String host, String id) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"schema\",\"action\":\"getJsonSchemaById\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"id\":\"%s\"}}", host, id);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryExchangeUrl(s2, exchange, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryExchange(s2, exchange);
    }

    public static Result<String> getJsonSchemaList(HttpServerExchange exchange, String url, String host, int offset, int limit, List<String> categories, List<String> tags) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("host", "lightapi.net");
        map.put("service", "schema");
        map.put("action", "getJsonSchemaList");
        map.put("version", "0.1.0");
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("host", host);
        dataMap.put("offset", offset);
        dataMap.put("limit", limit);
        dataMap.put("categories", categories);
        dataMap.put("tags", tags);
        map.put("data", dataMap);
        return HybridQueryClient.callQueryExchangeUrl(JsonMapper.toJson(map), exchange, url);
    }

    public static Result<String> getRuleById(HttpServerExchange exchange, String url, String host, String ruleId) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"rule\",\"action\":\"getRuleById\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"ruleId\":\"%s\"}}", host, ruleId);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getRuleByHost(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"rule\",\"action\":\"getRuleByHost\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getRuleByType(HttpServerExchange exchange, String url, String host, String ruleType) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"rule\",\"action\":\"getRuleByType\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"ruleType\":\"%s\"}}", host, ruleType);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getRuleByGroup(HttpServerExchange exchange, String url, String host, String groupId) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"rule\",\"action\":\"getRuleByGroup\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"groupId\":\"%s\"}}", host, groupId);
        return HybridQueryClient.callQueryExchangeUrl(s2, exchange, url);
    }

    public static Result<String> getConfigPropertyByPropertyId(HttpServerExchange exchange, String configId, String propertyId) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"config\",\"action\":\"getConfigPropertyByPropertyId\",\"version\":\"0.1.0\",\"data\":{\"configId\":\"%s\",\"propertyId\":\"%s\"}}", configId, propertyId);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryExchangeUrl(s2, exchange, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryExchange(s2, exchange);
    }

    public static Result<String> getDeploymentInstancePipeline(HttpServerExchange exchange, String hostId, String instanceId, String systemEnv, String runtimeEnv) {
        String s2 = String.format("{\"host\":\"lightapi.net\",\"service\":\"deployment\",\"action\":\"getDeploymentInstancePipeline\",\"version\":\"0.1.0\",\"data\":{\"hostId\":\"%s\",\"instanceId\":\"%s\",\"systemEnv\":\"%s\",\"runtimeEnv\":\"%s\"}}", hostId, instanceId, systemEnv, runtimeEnv);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryExchangeUrl(s2, exchange, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryExchange(s2, exchange);
    }
}

