/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.exporter;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public class EventMatcher {
    private final Set<String> normalizedPrefixes;
    private final boolean matchAll;

    public EventMatcher(String[] typePrefixes) {
        this.matchAll = Arrays.stream(typePrefixes).anyMatch("all"::equalsIgnoreCase);
        this.normalizedPrefixes = this.matchAll ? null : Arrays.stream(typePrefixes).map(String::toLowerCase).collect(Collectors.toSet());
    }

    public boolean matchesEvent(String eventType) {
        if (this.matchAll) {
            return true;
        }
        if (eventType == null) {
            return false;
        }
        String prefix = this.extractPrefix(eventType).toLowerCase();
        return this.normalizedPrefixes.contains(prefix);
    }

    private String extractPrefix(String eventType) {
        if (eventType == null || eventType.isEmpty()) {
            return "";
        }
        String processed = eventType.endsWith("Event") ? eventType.substring(0, eventType.length() - 5) : eventType;
        for (int i = 1; i < processed.length(); ++i) {
            if (!Character.isUpperCase(processed.charAt(i))) continue;
            return processed.substring(0, i);
        }
        return processed;
    }
}

