/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowMessages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PathTemplate
implements Comparable<PathTemplate> {
    private final String templateString;
    private final boolean template;
    private final String base;
    final List<Part> parts;
    private final Set<String> parameterNames;
    private final boolean trailingSlash;

    private PathTemplate(String templateString, boolean template, String base2, List<Part> parts, Set<String> parameterNames, boolean trailingSlash) {
        this.templateString = templateString;
        this.template = template;
        this.base = base2;
        this.parts = parts;
        this.parameterNames = Collections.unmodifiableSet(parameterNames);
        this.trailingSlash = trailingSlash;
    }

    public static PathTemplate create(String inputPath) {
        if (inputPath == null) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        if (!inputPath.startsWith("/")) {
            return PathTemplate.create("/" + inputPath);
        }
        String path = inputPath;
        int state = 0;
        String base2 = "";
        ArrayList<Part> parts = new ArrayList<Part>();
        int stringStart = 0;
        block15: for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '/') {
                        state = 1;
                        continue block15;
                    }
                    if (c == '*') {
                        base2 = path.substring(0, i + 1);
                        stringStart = i;
                        state = 5;
                        continue block15;
                    }
                    state = 0;
                    continue block15;
                }
                case 1: {
                    if (c == '{') {
                        base2 = path.substring(0, i);
                        stringStart = i + 1;
                        state = 2;
                        continue block15;
                    }
                    if (c == '*') {
                        base2 = path.substring(0, i + 1);
                        stringStart = i;
                        state = 5;
                        continue block15;
                    }
                    if (c == '/') continue block15;
                    state = 0;
                    continue block15;
                }
                case 2: {
                    if (c != '}') continue block15;
                    Part part = new Part(true, path.substring(stringStart, i));
                    parts.add(part);
                    stringStart = i;
                    state = 3;
                    continue block15;
                }
                case 3: {
                    if (c == '/') {
                        state = 4;
                        continue block15;
                    }
                    throw UndertowMessages.MESSAGES.couldNotParseUriTemplate(path, i);
                }
                case 4: {
                    if (c == '{') {
                        stringStart = i + 1;
                        state = 2;
                        continue block15;
                    }
                    if (c == '/') continue block15;
                    stringStart = i;
                    state = 5;
                    continue block15;
                }
                case 5: {
                    if (c != '/') continue block15;
                    Part part = new Part(false, path.substring(stringStart, i));
                    parts.add(part);
                    stringStart = i + 1;
                    state = 4;
                }
            }
        }
        boolean trailingSlash = false;
        switch (state) {
            case 1: {
                trailingSlash = true;
            }
            case 0: {
                base2 = path;
                break;
            }
            case 2: {
                throw UndertowMessages.MESSAGES.couldNotParseUriTemplate(path, path.length());
            }
            case 4: {
                trailingSlash = true;
                break;
            }
            case 5: {
                Part part = new Part(false, path.substring(stringStart));
                parts.add(part);
                break;
            }
        }
        HashSet<String> templates = new HashSet<String>();
        for (Part part : parts) {
            if (!part.template) continue;
            templates.add(part.part);
        }
        return new PathTemplate(path, state > 1 && !base2.contains("*"), base2, parts, templates, trailingSlash);
    }

    public boolean matches(String path, Map<String, String> pathParameters) {
        char currentChar;
        int i;
        if (!this.template && this.base.contains("*")) {
            int indexOf = this.base.indexOf("*");
            String startBase = this.base.substring(0, indexOf);
            if (!path.startsWith(startBase)) {
                return false;
            }
            pathParameters.put("*", path.substring(indexOf, path.length()));
            return true;
        }
        if (!path.startsWith(this.base)) {
            return false;
        }
        int baseLength = this.base.length();
        if (!this.template) {
            return path.length() == baseLength;
        }
        if (this.trailingSlash && path.charAt(path.length() - 1) != '/') {
            return false;
        }
        int currentPartPosition = 0;
        Part current = this.parts.get(currentPartPosition);
        int stringStart = baseLength;
        for (i = baseLength; i < path.length() && (currentChar = path.charAt(i)) != '?' && !current.part.equals("*"); ++i) {
            if (currentChar != '/') continue;
            String result2 = path.substring(stringStart, i);
            if (current.template) {
                pathParameters.put(current.part, result2);
            } else if (!result2.equals(current.part)) {
                pathParameters.clear();
                return false;
            }
            if (++currentPartPosition == this.parts.size()) {
                return i == path.length() - 1;
            }
            current = this.parts.get(currentPartPosition);
            stringStart = i + 1;
        }
        if (currentPartPosition + 1 != this.parts.size()) {
            pathParameters.clear();
            return false;
        }
        String result3 = path.substring(stringStart, i);
        if (current.part.equals("*")) {
            pathParameters.put(current.part, path.substring(stringStart, path.length()));
            return true;
        }
        if (current.template) {
            pathParameters.put(current.part, result3);
        } else if (!result3.equals(current.part)) {
            pathParameters.clear();
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathTemplate)) {
            return false;
        }
        PathTemplate that = (PathTemplate)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        int result2 = this.getTemplateString() != null ? this.getTemplateString().hashCode() : 0;
        result2 = 31 * result2 + (this.template ? 1 : 0);
        result2 = 31 * result2 + (this.getBase() != null ? this.getBase().hashCode() : 0);
        result2 = 31 * result2 + (this.parts != null ? this.parts.hashCode() : 0);
        result2 = 31 * result2 + (this.getParameterNames() != null ? this.getParameterNames().hashCode() : 0);
        return result2;
    }

    @Override
    public int compareTo(PathTemplate o) {
        if (this.template && !o.template) {
            return 1;
        }
        if (o.template && !this.template) {
            return -1;
        }
        int res = this.base.compareTo(o.base);
        if (res > 0) {
            return -1;
        }
        if (res < 0) {
            return 1;
        }
        if (!this.template) {
            return 0;
        }
        int i = 0;
        while (true) {
            int r;
            if (this.parts.size() == i) {
                if (o.parts.size() == i) {
                    return this.base.compareTo(o.base);
                }
                return 1;
            }
            if (o.parts.size() == i) {
                return -1;
            }
            Part thisPath = this.parts.get(i);
            Part otherPart = o.parts.get(i);
            if (thisPath.template && !otherPart.template) {
                return 1;
            }
            if (!thisPath.template && otherPart.template) {
                return -1;
            }
            if (!thisPath.template && (r = thisPath.part.compareTo(otherPart.part)) != 0) {
                return r;
            }
            ++i;
        }
    }

    public String getBase() {
        return this.base;
    }

    public String getTemplateString() {
        return this.templateString;
    }

    public Set<String> getParameterNames() {
        return this.parameterNames;
    }

    public String toString() {
        return "PathTemplate{template=" + this.template + ", base='" + this.base + "', parts=" + this.parts + "}";
    }

    private static class Part {
        final boolean template;
        final String part;

        private Part(boolean template, String part) {
            this.template = template;
            this.part = part;
        }

        public String toString() {
            return "Part{template=" + this.template + ", part='" + this.part + "'}";
        }
    }
}

