/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;

public class SessionListeners {
    private final List<SessionListener> sessionListeners = new CopyOnWriteArrayList<SessionListener>();

    public void addSessionListener(SessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public boolean removeSessionListener(SessionListener listener) {
        return this.sessionListeners.remove(listener);
    }

    public void clear() {
        this.sessionListeners.clear();
    }

    public void sessionCreated(Session session2, HttpServerExchange exchange) {
        for (SessionListener listener : this.sessionListeners) {
            listener.sessionCreated(session2, exchange);
        }
    }

    public void sessionDestroyed(Session session2, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
        ArrayList<SessionListener> listeners = new ArrayList<SessionListener>(this.sessionListeners);
        ListIterator iterator2 = listeners.listIterator(listeners.size());
        while (iterator2.hasPrevious()) {
            ((SessionListener)iterator2.previous()).sessionDestroyed(session2, exchange, reason);
        }
    }

    public void attributeAdded(Session session2, String name2, Object value) {
        for (SessionListener listener : this.sessionListeners) {
            listener.attributeAdded(session2, name2, value);
        }
    }

    public void attributeUpdated(Session session2, String name2, Object newValue, Object oldValue) {
        for (SessionListener listener : this.sessionListeners) {
            listener.attributeUpdated(session2, name2, newValue, oldValue);
        }
    }

    public void attributeRemoved(Session session2, String name2, Object oldValue) {
        for (SessionListener listener : this.sessionListeners) {
            listener.attributeRemoved(session2, name2, oldValue);
        }
    }

    public void sessionIdChanged(Session session2, String oldSessionId) {
        for (SessionListener listener : this.sessionListeners) {
            listener.sessionIdChanged(session2, oldSessionId);
        }
    }
}

