/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowMessages;
import io.undertow.server.handlers.resource.PathResourceManager;
import java.io.File;

public class FileResourceManager
extends PathResourceManager {
    public FileResourceManager(File base2) {
        this(base2, 1024L, true, false, null);
    }

    public FileResourceManager(File base2, long transferMinSize) {
        this(base2, transferMinSize, true, false, null);
    }

    public FileResourceManager(File base2, long transferMinSize, boolean caseSensitive) {
        this(base2, transferMinSize, caseSensitive, false, null);
    }

    public FileResourceManager(File base2, long transferMinSize, boolean followLinks, String ... safePaths) {
        this(base2, transferMinSize, true, followLinks, safePaths);
    }

    protected FileResourceManager(long transferMinSize, boolean caseSensitive, boolean followLinks, String ... safePaths) {
        super(transferMinSize, caseSensitive, followLinks, safePaths);
    }

    public FileResourceManager(File base2, long transferMinSize, boolean caseSensitive, boolean followLinks, String ... safePaths) {
        super(base2.toPath(), transferMinSize, caseSensitive, followLinks, safePaths);
    }

    public File getBase() {
        return new File(this.base);
    }

    @Override
    public FileResourceManager setBase(File base2) {
        if (base2 == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        Object basePath2 = base2.getAbsolutePath();
        if (!((String)basePath2).endsWith("/")) {
            basePath2 = (String)basePath2 + "/";
        }
        this.base = basePath2;
        return this;
    }
}

