/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.util.HeaderToken;
import io.undertow.util.HeaderTokenParser;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public enum DigestAuthorizationToken implements HeaderToken
{
    USERNAME(Headers.USERNAME, true),
    REALM(Headers.REALM, true),
    NONCE(Headers.NONCE, true),
    DIGEST_URI(Headers.URI, true),
    RESPONSE(Headers.RESPONSE, true),
    ALGORITHM(Headers.ALGORITHM, true),
    CNONCE(Headers.CNONCE, true),
    OPAQUE(Headers.OPAQUE, true),
    MESSAGE_QOP(Headers.QOP, true),
    NONCE_COUNT(Headers.NONCE_COUNT, false),
    AUTH_PARAM(Headers.AUTH_PARAM, false);

    private static final HeaderTokenParser<DigestAuthorizationToken> TOKEN_PARSER;
    private final String name;
    private final boolean quoted;

    private DigestAuthorizationToken(HttpString name2, boolean quoted) {
        this.name = name2.toString();
        this.quoted = quoted;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAllowQuoted() {
        return this.quoted;
    }

    public static Map<DigestAuthorizationToken, String> parseHeader(String header) {
        return TOKEN_PARSER.parseHeader(header);
    }

    static {
        LinkedHashMap<String, DigestAuthorizationToken> expected = new LinkedHashMap<String, DigestAuthorizationToken>(DigestAuthorizationToken.values().length);
        for (DigestAuthorizationToken current : DigestAuthorizationToken.values()) {
            expected.put(current.getName(), current);
        }
        TOKEN_PARSER = new HeaderTokenParser(Collections.unmodifiableMap(expected));
    }
}

