/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.alpn;

import io.undertow.protocols.alpn.ALPNEngineManager;
import io.undertow.protocols.alpn.ALPNProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.function.Function;
import javax.net.ssl.SSLEngine;

public class ALPNManager {
    private final ALPNProvider[] alpnProviders;
    private final ALPNEngineManager[] alpnEngineManagers;
    public static final ALPNManager INSTANCE = new ALPNManager(ALPNManager.class.getClassLoader());

    public ALPNManager(ClassLoader classLoader2) {
        ServiceLoader<ALPNProvider> loader = ServiceLoader.load(ALPNProvider.class, classLoader2);
        ArrayList<ALPNProvider> provider = new ArrayList<ALPNProvider>();
        for (ALPNProvider prov : loader) {
            provider.add(prov);
        }
        Collections.sort(provider, new Comparator<ALPNProvider>(){

            @Override
            public int compare(ALPNProvider o1, ALPNProvider o2) {
                return Integer.compare(o2.getPriority(), o1.getPriority());
            }
        });
        this.alpnProviders = provider.toArray(new ALPNProvider[0]);
        ServiceLoader<ALPNEngineManager> managerLoader = ServiceLoader.load(ALPNEngineManager.class, classLoader2);
        ArrayList<ALPNEngineManager> managers = new ArrayList<ALPNEngineManager>();
        for (ALPNEngineManager manager : managerLoader) {
            managers.add(manager);
        }
        Collections.sort(managers, new Comparator<ALPNEngineManager>(){

            @Override
            public int compare(ALPNEngineManager o1, ALPNEngineManager o2) {
                return Integer.compare(o2.getPriority(), o1.getPriority());
            }
        });
        this.alpnEngineManagers = managers.toArray(new ALPNEngineManager[0]);
    }

    public ALPNProvider getProvider(SSLEngine engine) {
        for (ALPNProvider provider : this.alpnProviders) {
            if (!provider.isEnabled(engine)) continue;
            return provider;
        }
        return null;
    }

    public void registerEngineCallback(SSLEngine original, Function<SSLEngine, SSLEngine> selectionFunction) {
        for (ALPNEngineManager manager : this.alpnEngineManagers) {
            if (!manager.registerEngine(original, selectionFunction)) continue;
            return;
        }
    }
}

