/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.broadcom;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.networknt.config.Config;
import com.networknt.exception.ClientException;
import com.networknt.http.client.HttpClientRequest;
import com.networknt.http.client.HttpMethod;
import com.networknt.metrics.TimeSeriesDbSender;
import io.dropwizard.metrics.broadcom.EPAgentMetric;
import io.dropwizard.metrics.broadcom.EPAgentMetricRequest;
import io.dropwizard.metrics.influxdb.data.InfluxDbPoint;
import io.dropwizard.metrics.influxdb.data.InfluxDbWriteObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APMEPAgentSender
implements TimeSeriesDbSender {
    private static final Logger logger = LoggerFactory.getLogger(APMEPAgentSender.class);
    private final String path;
    private final String serviceId;
    private final String productName;
    private final HttpClientRequest httpClientRequest = new HttpClientRequest();
    private final URL url;
    private final InfluxDbWriteObject influxDbWriteObject;

    public APMEPAgentSender(String protocol, String hostname, int port, String epAgentPath, String serviceId, String productName) throws MalformedURLException {
        this(protocol, hostname, port, epAgentPath, serviceId, productName, TimeUnit.MILLISECONDS);
    }

    public APMEPAgentSender(String protocol, String hostname, int port, String epAgentPath, String serviceId, String productName, TimeUnit timePrecision) throws MalformedURLException {
        this.url = new URL(protocol, hostname, port, "");
        this.path = epAgentPath;
        this.serviceId = serviceId;
        this.productName = productName;
        if (logger.isInfoEnabled()) {
            logger.info("APMEPAgentSender is created with path = {}  and host = {}", (Object)this.path, (Object)this.url);
        }
        this.influxDbWriteObject = new InfluxDbWriteObject(timePrecision);
    }

    @Override
    public void flush() {
        this.influxDbWriteObject.setPoints(new HashSet<InfluxDbPoint>());
    }

    @Override
    public boolean hasSeriesData() {
        return this.influxDbWriteObject.getPoints() != null && !this.influxDbWriteObject.getPoints().isEmpty();
    }

    @Override
    public void appendPoints(InfluxDbPoint point) {
        if (point != null) {
            this.influxDbWriteObject.getPoints().add(point);
        }
    }

    @Override
    public int writeData() throws Exception {
        String body = this.convertInfluxDBWriteObjectToJSON(this.influxDbWriteObject);
        if (logger.isTraceEnabled()) {
            logger.trace("APMEPAgentSender is sending data to host = {} with body = {}", (Object)this.url, (Object)body);
        }
        HttpRequest.Builder builder = this.httpClientRequest.initBuilder(this.url.toString() + this.path, HttpMethod.POST, Optional.of(body));
        builder.setHeader("Content-Type", "application/json");
        HttpResponse<?> response = this.httpClientRequest.send(builder, HttpResponse.BodyHandlers.ofString());
        int statusCode = response.statusCode();
        if (statusCode >= 200 && statusCode < 300) {
            return statusCode;
        }
        logger.error("Server returned HTTP response code: {} for path: {} and host: {} with content :'{}'", statusCode, this.path, this.url, response.body());
        throw new ClientException("Server returned HTTP response code: " + statusCode + "for path: " + this.path + " and host: " + String.valueOf(this.url) + " with content :'" + (String)response.body() + "'");
    }

    private String convertInfluxDBWriteObjectToJSON(InfluxDbWriteObject influxDbWriteObject) throws ClientException {
        EPAgentMetricRequest epAgentMetricRequest = new EPAgentMetricRequest();
        ArrayList<EPAgentMetric> epAgentMetricList = new ArrayList<EPAgentMetric>();
        for (InfluxDbPoint point : influxDbWriteObject.getPoints()) {
            EPAgentMetric epAgentMetric = new EPAgentMetric();
            epAgentMetric.setName(this.convertName(point));
            double milliseconds = Double.parseDouble(point.getValue());
            int roundedMilliseconds = (int)Math.round(milliseconds);
            epAgentMetric.setValue(Integer.toString(roundedMilliseconds));
            epAgentMetric.setType("PerIntervalCounter");
            epAgentMetricList.add(epAgentMetric);
        }
        epAgentMetricRequest.setMetrics(epAgentMetricList);
        String json = "";
        try {
            json = Config.getInstance().getMapper().writeValueAsString(epAgentMetricRequest);
        }
        catch (JsonProcessingException e) {
            throw new ClientException(e);
        }
        return json;
    }

    private String convertName(InfluxDbPoint point) {
        StringJoiner metricNameJoiner = new StringJoiner("|");
        metricNameJoiner.add(this.productName);
        metricNameJoiner.add(this.serviceId);
        for (Map.Entry<String, String> pair : point.getTags().entrySet()) {
            String value = pair.getValue();
            if (value != null) {
                metricNameJoiner.add(pair.getValue());
                continue;
            }
            metricNameJoiner.add("null");
        }
        return metricNameJoiner.toString() + ":" + point.getMeasurement();
    }

    @Override
    public void setTags(Map<String, String> tags) {
        if (tags != null) {
            this.influxDbWriteObject.setTags(tags);
        }
    }
}

