/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics;

import io.dropwizard.metrics.MetricRegistry;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SharedMetricRegistries {
    private static final ConcurrentMap<String, MetricRegistry> REGISTRIES = new ConcurrentHashMap<String, MetricRegistry>();
    private static volatile String defaultRegistryName = null;

    private SharedMetricRegistries() {
    }

    public static void clear() {
        REGISTRIES.clear();
    }

    public static Set<String> names() {
        return REGISTRIES.keySet();
    }

    public static void remove(String key) {
        REGISTRIES.remove(key);
    }

    public static MetricRegistry add(String name2, MetricRegistry registry) {
        return REGISTRIES.putIfAbsent(name2, registry);
    }

    public static MetricRegistry getOrCreate(String name2) {
        MetricRegistry existing = (MetricRegistry)REGISTRIES.get(name2);
        if (existing == null) {
            MetricRegistry created = new MetricRegistry();
            MetricRegistry raced = SharedMetricRegistries.add(name2, created);
            if (raced == null) {
                return created;
            }
            return raced;
        }
        return existing;
    }

    public static synchronized MetricRegistry setDefault(String name2) {
        MetricRegistry registry = SharedMetricRegistries.getOrCreate(name2);
        return SharedMetricRegistries.setDefault(name2, registry);
    }

    public static MetricRegistry setDefault(String name2, MetricRegistry metricRegistry) {
        if (defaultRegistryName == null) {
            defaultRegistryName = name2;
            SharedMetricRegistries.add(name2, metricRegistry);
            return metricRegistry;
        }
        throw new IllegalStateException("Default metric registry name is already set.");
    }

    public static MetricRegistry getDefault() {
        if (defaultRegistryName != null) {
            return SharedMetricRegistries.getOrCreate(defaultRegistryName);
        }
        throw new IllegalStateException("Default registry name has not been set.");
    }
}

