/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics;

import io.dropwizard.metrics.Counter;
import io.dropwizard.metrics.Meter;
import io.dropwizard.metrics.MetricRegistry;
import io.dropwizard.metrics.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class InstrumentedExecutorService
implements ExecutorService {
    private static final AtomicLong nameCounter = new AtomicLong();
    private final ExecutorService delegate;
    private final Meter submitted;
    private final Counter running;
    private final Meter completed;
    private final Timer duration;
    private final Meter rejected;

    public InstrumentedExecutorService(ExecutorService delegate, MetricRegistry registry) {
        this(delegate, registry, "instrumented-delegate-" + nameCounter.incrementAndGet());
    }

    public InstrumentedExecutorService(ExecutorService delegate, MetricRegistry registry, String name2) {
        this.delegate = delegate;
        this.submitted = registry.meter(MetricRegistry.name(name2, "submitted"));
        this.running = registry.counter(MetricRegistry.name(name2, "running"));
        this.completed = registry.meter(MetricRegistry.name(name2, "completed"));
        this.duration = registry.timer(MetricRegistry.name(name2, "duration"));
        this.rejected = registry.meter(MetricRegistry.name(name2, "rejected"));
    }

    @Override
    public void execute(@Nonnull Runnable runnable) {
        this.submitted.mark();
        try {
            this.delegate.execute(new InstrumentedRunnable(runnable));
        }
        catch (RejectedExecutionException e) {
            this.rejected.mark();
            throw e;
        }
    }

    @Override
    @Nonnull
    public Future<?> submit(@Nonnull Runnable runnable) {
        this.submitted.mark();
        try {
            return this.delegate.submit(new InstrumentedRunnable(runnable));
        }
        catch (RejectedExecutionException e) {
            this.rejected.mark();
            throw e;
        }
    }

    @Override
    @Nonnull
    public <T> Future<T> submit(@Nonnull Runnable runnable, T result2) {
        this.submitted.mark();
        try {
            return this.delegate.submit(new InstrumentedRunnable(runnable), result2);
        }
        catch (RejectedExecutionException e) {
            this.rejected.mark();
            throw e;
        }
    }

    @Override
    @Nonnull
    public <T> Future<T> submit(@Nonnull Callable<T> task) {
        this.submitted.mark();
        try {
            return this.delegate.submit(new InstrumentedCallable<T>(task));
        }
        catch (RejectedExecutionException e) {
            this.rejected.mark();
            throw e;
        }
    }

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.submitted.mark(tasks.size());
        Collection<Callable<T>> instrumented = this.instrument(tasks);
        try {
            return this.delegate.invokeAll(instrumented);
        }
        catch (RejectedExecutionException e) {
            this.rejected.mark();
            throw e;
        }
    }

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> tasks, long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        this.submitted.mark(tasks.size());
        Collection<Callable<T>> instrumented = this.instrument(tasks);
        try {
            return this.delegate.invokeAll(instrumented, timeout, unit);
        }
        catch (RejectedExecutionException e) {
            this.rejected.mark();
            throw e;
        }
    }

    @Override
    @Nonnull
    public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> tasks) throws ExecutionException, InterruptedException {
        this.submitted.mark(tasks.size());
        Collection<Callable<T>> instrumented = this.instrument(tasks);
        try {
            return this.delegate.invokeAny(instrumented);
        }
        catch (RejectedExecutionException e) {
            this.rejected.mark();
            throw e;
        }
    }

    @Override
    public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> tasks, long timeout, @Nonnull TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        this.submitted.mark(tasks.size());
        Collection<Callable<T>> instrumented = this.instrument(tasks);
        try {
            return this.delegate.invokeAny(instrumented, timeout, unit);
        }
        catch (RejectedExecutionException e) {
            this.rejected.mark();
            throw e;
        }
    }

    private <T> Collection<? extends Callable<T>> instrument(Collection<? extends Callable<T>> tasks) {
        ArrayList instrumented = new ArrayList(tasks.size());
        instrumented.addAll(tasks.stream().map(x$0 -> new InstrumentedCallable(x$0)).collect(Collectors.toList()));
        return instrumented;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    @Nonnull
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, @Nonnull TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.awaitTermination(l, timeUnit);
    }

    private class InstrumentedRunnable
    implements Runnable {
        private final Runnable task;

        InstrumentedRunnable(Runnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            InstrumentedExecutorService.this.running.inc();
            Timer.Context context = InstrumentedExecutorService.this.duration.time();
            try {
                this.task.run();
            }
            finally {
                context.stop();
                InstrumentedExecutorService.this.running.dec();
                InstrumentedExecutorService.this.completed.mark();
            }
        }
    }

    private class InstrumentedCallable<T>
    implements Callable<T> {
        private final Callable<T> callable;

        InstrumentedCallable(Callable<T> callable) {
            this.callable = callable;
        }

        @Override
        public T call() throws Exception {
            InstrumentedExecutorService.this.running.inc();
            Timer.Context context = InstrumentedExecutorService.this.duration.time();
            try {
                T t2 = this.callable.call();
                return t2;
            }
            finally {
                context.stop();
                InstrumentedExecutorService.this.running.dec();
                InstrumentedExecutorService.this.completed.mark();
            }
        }
    }
}

