/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.wrapper;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.wrapper.CompositeDeserializerConfig;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeDeserializer
implements Deserializer<Object> {
    protected Logger log = LoggerFactory.getLogger(CompositeDeserializer.class);
    protected static final byte MAGIC_BYTE = 0;
    private boolean isKey;
    private Deserializer<?> oldDeserializer;
    private Deserializer<?> confluentDeserializer;
    private SchemaRegistryClient schemaRegistryClient;

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        this.configure(new CompositeDeserializerConfig(configs), isKey);
    }

    protected void configure(CompositeDeserializerConfig config, boolean isKey) {
        this.isKey = isKey;
        Map<String, Object> originals = config.originals();
        this.oldDeserializer = config.getConfiguredInstance("composite.old.deserializer", Deserializer.class);
        this.oldDeserializer.configure(originals, isKey);
        this.confluentDeserializer = config.getConfiguredInstance("composite.confluent.deserializer", Deserializer.class);
        this.confluentDeserializer.configure(originals, isKey);
        this.schemaRegistryClient = this.getSchemaRegistryClient();
    }

    @Override
    public Object deserialize(String topic, byte[] bytes) {
        return this.deserialize(topic, null, bytes);
    }

    @Override
    public Object deserialize(String topic, Headers headers, byte[] bytes) {
        int schemaId;
        if (bytes == null) {
            return null;
        }
        String subject = this.isKey ? topic + "-key" : topic + "-value";
        if (this.isValidSchemaId(subject, schemaId = this.getSchemaId(ByteBuffer.wrap(bytes)))) {
            return this.confluentDeserializer.deserialize(topic, headers, bytes);
        }
        return this.oldDeserializer.deserialize(topic, bytes);
    }

    private int getSchemaId(ByteBuffer payload) {
        if (payload == null || payload.get() != 0) {
            return -1;
        }
        return payload.getInt();
    }

    protected boolean isValidSchemaId(String subject, int id) {
        if (id == -1) {
            return false;
        }
        try {
            ParsedSchema schema = this.schemaRegistryClient.getSchemaBySubjectAndId(subject, id);
            int savedId = this.schemaRegistryClient.getId(subject, schema);
            return id == savedId;
        }
        catch (Exception e) {
            this.log.warn("Error while validating schema id", e);
            return false;
        }
    }

    private SchemaRegistryClient getSchemaRegistryClient() {
        if (!(this.confluentDeserializer instanceof AbstractKafkaSchemaSerDe)) {
            throw new IllegalArgumentException("Value of 'confluent.deserializer' property must be an instance of 'io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe'");
        }
        return ((AbstractKafkaSchemaSerDe)((Object)this.confluentDeserializer)).getSchemaRegistryClient();
    }

    @Override
    public void close() {
        this.oldDeserializer.close();
        this.confluentDeserializer.close();
    }
}

