/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.utils;

import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MavenConfigGenerator {
    public static void main(String[] args2) throws IOException {
        String inputDir = args2.length > 0 ? args2[0] : ".";
        String outputFile = args2.length > 1 ? args2[1] : null;
        String replacementChar = args2.length > 2 ? args2[2] : null;
        TreeMap<Path, List<String>> schemas = new TreeMap<Path, List<String>>();
        Path dir = Paths.get(inputDir, new String[0]);
        Files.walk(dir, new FileVisitOption[0]).forEach(path -> MavenConfigGenerator.processFile(schemas, dir, path));
        PrintWriter printWriter = outputFile != null ? new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8)) : new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
        MavenConfigGenerator.printSubjects(printWriter, schemas, replacementChar);
        MavenConfigGenerator.printSchemaTypes(printWriter, schemas, replacementChar);
        MavenConfigGenerator.printReferences(printWriter, schemas, replacementChar);
        printWriter.close();
    }

    private static void processFile(Map<Path, List<String>> schemas, Path dir, Path path) {
        try {
            Path relative = dir.relativize(path);
            File file = path.toFile();
            String name2 = relative.toString();
            if (file.isFile() && name2.endsWith(".proto")) {
                ProtoFileElement proto = MavenConfigGenerator.getSchema(path).rawSchema();
                List<String> imports = proto.getImports();
                schemas.put(relative, imports);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String toSubject(String path, String replacementChar, boolean inTag) {
        String subject = path.endsWith(".proto") ? path.substring(0, path.length() - ".proto".length()) : path;
        if (replacementChar != null) {
            subject = subject.replace(String.valueOf(File.separatorChar), replacementChar);
        } else if (inTag) {
            subject = subject.replace(String.valueOf(File.separatorChar), "_x2F");
        }
        return subject;
    }

    private static ProtobufSchema getSchema(Path path) throws IOException {
        String schema = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        return new ProtobufSchema(schema);
    }

    private static void printSchemaTypes(PrintWriter printWriter, Map<Path, List<String>> schemas, String replacementChar) {
        printWriter.println("<schemaTypes>");
        for (Map.Entry<Path, List<String>> entry : schemas.entrySet()) {
            Path path = entry.getKey();
            String subject = MavenConfigGenerator.toSubject(path.toString(), replacementChar, true);
            printWriter.print("  <");
            printWriter.print(subject);
            printWriter.print(">PROTOBUF</");
            printWriter.print(subject);
            printWriter.println(">");
        }
        printWriter.println("</schemaTypes>");
    }

    private static void printSubjects(PrintWriter printWriter, Map<Path, List<String>> schemas, String replacementChar) {
        printWriter.println("<subjects>");
        for (Map.Entry<Path, List<String>> entry : schemas.entrySet()) {
            Path path = entry.getKey();
            String subject = MavenConfigGenerator.toSubject(path.toString(), replacementChar, true);
            printWriter.print("  <");
            printWriter.print(subject);
            printWriter.print(">");
            printWriter.print(path);
            printWriter.print("</");
            printWriter.print(subject);
            printWriter.println(">");
        }
        printWriter.println("</subjects>");
    }

    private static void printReferences(PrintWriter printWriter, Map<Path, List<String>> schemas, String replacementChar) {
        printWriter.println("<references>");
        for (Map.Entry<Path, List<String>> entry : schemas.entrySet()) {
            Path path = entry.getKey();
            List<String> imports = entry.getValue();
            String subject = MavenConfigGenerator.toSubject(path.toString(), replacementChar, true);
            if (imports.isEmpty()) {
                printWriter.print("  <");
                printWriter.print(subject);
                printWriter.println("/>");
                continue;
            }
            printWriter.print("  <");
            printWriter.print(subject);
            printWriter.println(">");
            for (String dep : imports) {
                printWriter.println("    <reference>");
                printWriter.print("      <name>");
                printWriter.print(dep);
                printWriter.println("</name>");
                printWriter.print("      <subject>");
                printWriter.print(MavenConfigGenerator.toSubject(dep, replacementChar, false));
                printWriter.println("</subject>");
                printWriter.println("    </reference>");
            }
            printWriter.print("  </");
            printWriter.print(subject);
            printWriter.println(">");
        }
        printWriter.println("</references>");
    }
}

