/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.utils;

import java.util.Objects;

public class Edge<V, T> {
    private final V source;
    private final V target;
    private final T value;

    public Edge(V source2, V target, T value) {
        this.source = source2;
        this.target = target;
        this.value = value;
    }

    public Edge<V, T> reverse() {
        return new Edge<V, T>(this.target(), this.source(), this.value());
    }

    public V source() {
        return this.source;
    }

    public V target() {
        return this.target;
    }

    public T value() {
        return this.value;
    }

    public String toString() {
        return "Edge{src=" + this.source + ",tgt=" + this.target + ",val=" + this.value + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Edge that = (Edge)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.target, this.value);
    }
}

