/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.schema;

import io.confluent.kafka.schemaregistry.json.diff.SchemaDiff;
import io.confluent.kafka.schemaregistry.json.schema.CombinedSchemaExt;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ConditionalSchema;
import org.everit.json.schema.ConstSchema;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.NotSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.TrueSchema;

public class SchemaUtils {
    public static Schema.Builder<?> schemaToBuilder(Schema s2) {
        if (s2 instanceof TrueSchema) {
            return SchemaUtils.toBuilder((TrueSchema)s2);
        }
        if (s2 instanceof ArraySchema) {
            return SchemaUtils.toBuilder((ArraySchema)s2);
        }
        if (s2 instanceof BooleanSchema) {
            return SchemaUtils.toBuilder((BooleanSchema)s2);
        }
        if (s2 instanceof CombinedSchemaExt) {
            return SchemaUtils.toBuilder((CombinedSchemaExt)s2);
        }
        if (s2 instanceof ConditionalSchema) {
            return SchemaUtils.toBuilder((ConditionalSchema)s2);
        }
        if (s2 instanceof ConstSchema) {
            return SchemaUtils.toBuilder((ConstSchema)s2);
        }
        if (s2 instanceof EmptySchema) {
            return SchemaUtils.toBuilder((EmptySchema)s2);
        }
        if (s2 instanceof EnumSchema) {
            return SchemaUtils.toBuilder((EnumSchema)s2);
        }
        if (s2 instanceof FalseSchema) {
            return SchemaUtils.toBuilder((FalseSchema)s2);
        }
        if (s2 instanceof NotSchema) {
            return SchemaUtils.toBuilder((NotSchema)s2);
        }
        if (s2 instanceof NullSchema) {
            return SchemaUtils.toBuilder((NullSchema)s2);
        }
        if (s2 instanceof NumberSchema) {
            return SchemaUtils.toBuilder((NumberSchema)s2);
        }
        if (s2 instanceof ObjectSchema) {
            return SchemaUtils.toBuilder((ObjectSchema)s2);
        }
        if (s2 instanceof ReferenceSchema) {
            return SchemaUtils.toBuilder((ReferenceSchema)s2);
        }
        if (s2 instanceof StringSchema) {
            return SchemaUtils.toBuilder((StringSchema)s2);
        }
        throw new IllegalArgumentException();
    }

    public static ArraySchema.Builder toBuilder(ArraySchema s2) {
        return SchemaUtils.merge(ArraySchema.builder().requiresArray(false), s2);
    }

    public static BooleanSchema.Builder toBuilder(BooleanSchema s2) {
        return SchemaUtils.merge(BooleanSchema.builder(), s2);
    }

    public static CombinedSchemaExt.Builder toBuilder(CombinedSchemaExt s2) {
        return SchemaUtils.merge(CombinedSchemaExt.builder(), s2);
    }

    public static ConditionalSchema.Builder toBuilder(ConditionalSchema s2) {
        return SchemaUtils.merge(ConditionalSchema.builder(), s2);
    }

    public static ConstSchema.ConstSchemaBuilder toBuilder(ConstSchema s2) {
        return SchemaUtils.merge(ConstSchema.builder(), s2);
    }

    public static EmptySchema.Builder toBuilder(EmptySchema s2) {
        return SchemaUtils.merge(EmptySchema.builder(), s2);
    }

    public static EnumSchema.Builder toBuilder(EnumSchema s2) {
        return SchemaUtils.merge(EnumSchema.builder(), s2);
    }

    public static FalseSchema.Builder toBuilder(FalseSchema s2) {
        return SchemaUtils.merge(FalseSchema.builder(), s2);
    }

    public static NotSchema.Builder toBuilder(NotSchema s2) {
        return SchemaUtils.merge(NotSchema.builder(), s2);
    }

    public static NullSchema.Builder toBuilder(NullSchema s2) {
        return SchemaUtils.merge(NullSchema.builder(), s2);
    }

    public static NumberSchema.Builder toBuilder(NumberSchema s2) {
        return SchemaUtils.merge(NumberSchema.builder().requiresNumber(false), s2);
    }

    public static ObjectSchema.Builder toBuilder(ObjectSchema s2) {
        return SchemaUtils.merge(ObjectSchema.builder().requiresObject(false), s2);
    }

    public static ReferenceSchema.Builder toBuilder(ReferenceSchema s2) {
        return SchemaUtils.merge(ReferenceSchema.builder(), s2);
    }

    public static StringSchema.Builder toBuilder(StringSchema s2) {
        return SchemaUtils.merge(StringSchema.builder().requiresString(false), s2);
    }

    public static TrueSchema.Builder toBuilder(TrueSchema s2) {
        return SchemaUtils.merge(TrueSchema.builder(), s2);
    }

    public static ArraySchema.Builder merge(ArraySchema.Builder builder, ArraySchema s2) {
        SchemaUtils.copyGenericAttrs(builder, s2);
        if (s2.requiresArray()) {
            builder.requiresArray(true);
        }
        if (s2.getMinItems() != null) {
            builder.minItems(s2.getMinItems());
        }
        if (s2.getMaxItems() != null) {
            builder.maxItems(s2.getMaxItems());
        }
        if (s2.needsUniqueItems()) {
            builder.uniqueItems(true);
        }
        if (s2.getAllItemSchema() != null) {
            builder.allItemSchema(s2.getAllItemSchema());
        }
        if (s2.getItemSchemas() != null) {
            for (Schema i : s2.getItemSchemas()) {
                builder.addItemSchema(i);
            }
        }
        if (!s2.permitsAdditionalItems()) {
            builder.additionalItems(false);
        }
        if (s2.getSchemaOfAdditionalItems() != null) {
            builder.schemaOfAdditionalItems(s2.getSchemaOfAdditionalItems());
        }
        if (s2.getContainedItemSchema() != null) {
            builder.containsItemSchema(s2.getContainedItemSchema());
        }
        return builder;
    }

    public static BooleanSchema.Builder merge(BooleanSchema.Builder builder, BooleanSchema s2) {
        SchemaUtils.copyGenericAttrs(builder, s2);
        return builder;
    }

    public static CombinedSchemaExt.Builder merge(CombinedSchemaExt.Builder builder, CombinedSchemaExt s2) {
        SchemaUtils.copyGenericAttrs(builder, s2);
        builder.isGenerated(s2.isGenerated());
        builder.criterion(s2.getCriterion());
        builder.subschemas((Collection)s2.getSubschemas());
        return builder;
    }

    public static ConditionalSchema.Builder merge(ConditionalSchema.Builder builder, ConditionalSchema s2) {
        SchemaUtils.copyGenericAttrs(builder, s2);
        if (s2.getIfSchema().isPresent()) {
            builder.ifSchema(s2.getIfSchema().get());
        }
        if (s2.getThenSchema().isPresent()) {
            builder.thenSchema(s2.getThenSchema().get());
        }
        if (s2.getElseSchema().isPresent()) {
            builder.elseSchema(s2.getElseSchema().get());
        }
        return builder;
    }

    public static ConstSchema.ConstSchemaBuilder merge(ConstSchema.ConstSchemaBuilder builder, ConstSchema s2) {
        SchemaUtils.copyGenericAttrs(builder, s2);
        if (s2.getPermittedValue() != null) {
            builder.permittedValue(s2.getPermittedValue());
        }
        return builder;
    }

    public static EmptySchema.Builder merge(EmptySchema.Builder builder, EmptySchema s2) {
        SchemaUtils.copyGenericAttrs(builder, s2);
        return builder;
    }

    public static EnumSchema.Builder merge(EnumSchema.Builder builder, EnumSchema s2) {
        SchemaUtils.copyGenericAttrs(builder, s2);
        if (s2.getPossibleValuesAsList() != null) {
            builder.possibleValues(s2.getPossibleValuesAsList());
        }
        return builder;
    }

    public static FalseSchema.Builder merge(FalseSchema.Builder builder, FalseSchema s2) {
        SchemaUtils.copyGenericAttrs(builder, s2);
        return builder;
    }

    public static NotSchema.Builder merge(NotSchema.Builder builder, NotSchema s2) {
        SchemaUtils.copyGenericAttrs(builder, s2);
        if (s2.getMustNotMatch() != null) {
            builder.mustNotMatch(s2.getMustNotMatch());
        }
        return builder;
    }

    public static NullSchema.Builder merge(NullSchema.Builder builder, NullSchema s2) {
        SchemaUtils.copyGenericAttrs(builder, s2);
        return builder;
    }

    public static NumberSchema.Builder merge(NumberSchema.Builder builder, NumberSchema s2) {
        SchemaUtils.copyGenericAttrs(builder, s2);
        if (s2.getMinimum() != null) {
            builder.minimum(s2.getMinimum());
        }
        if (s2.getMaximum() != null) {
            builder.maximum(s2.getMaximum());
        }
        if (s2.getExclusiveMinimumLimit() != null) {
            builder.exclusiveMinimum(s2.getExclusiveMinimumLimit());
        }
        if (s2.getExclusiveMaximumLimit() != null) {
            builder.exclusiveMaximum(s2.getExclusiveMaximumLimit());
        }
        if (s2.getMultipleOf() != null) {
            builder.multipleOf(s2.getMultipleOf());
        }
        if (s2.isRequiresNumber()) {
            builder.requiresNumber(true);
        }
        if (s2.requiresInteger()) {
            builder.requiresInteger(true);
        }
        return builder;
    }

    public static ObjectSchema.Builder merge(ObjectSchema.Builder builder, ObjectSchema s2) {
        SchemaUtils.copyGenericAttrs(builder, s2);
        if (s2.getPatternProperties() != null) {
            for (Map.Entry<Pattern, Schema> entry : s2.getPatternProperties().entrySet()) {
                builder.patternProperty(entry.getKey(), entry.getValue());
            }
        }
        if (s2.requiresObject()) {
            builder.requiresObject(true);
        }
        if (s2.getPropertySchemas() != null) {
            for (Map.Entry<Object, Schema> entry : s2.getPropertySchemas().entrySet()) {
                builder.addPropertySchema((String)entry.getKey(), entry.getValue());
            }
        }
        if (!s2.permitsAdditionalProperties()) {
            builder.additionalProperties(false);
        }
        if (s2.getSchemaOfAdditionalProperties() != null) {
            builder.schemaOfAdditionalProperties(s2.getSchemaOfAdditionalProperties());
        }
        if (s2.getRequiredProperties() != null) {
            for (String string : s2.getRequiredProperties()) {
                builder.addRequiredProperty(string);
            }
        }
        if (s2.getMinProperties() != null) {
            builder.minProperties(s2.getMinProperties());
        }
        if (s2.getMaxProperties() != null) {
            builder.maxProperties(s2.getMaxProperties());
        }
        if (s2.getPropertyDependencies() != null) {
            for (Map.Entry entry : s2.getPropertyDependencies().entrySet()) {
                for (String p : (Set)entry.getValue()) {
                    builder.propertyDependency((String)entry.getKey(), p);
                }
            }
        }
        if (s2.getSchemaDependencies() != null) {
            for (Map.Entry entry : s2.getSchemaDependencies().entrySet()) {
                builder.schemaDependency((String)entry.getKey(), (Schema)entry.getValue());
            }
        }
        if (s2.getPropertyNameSchema() != null) {
            builder.propertyNameSchema(s2.getPropertyNameSchema());
        }
        return builder;
    }

    public static ReferenceSchema.Builder merge(ReferenceSchema.Builder builder, ReferenceSchema s2) {
        SchemaUtils.copyGenericAttrs(builder, s2);
        if (s2.getReferenceValue() != null) {
            builder.refValue(s2.getReferenceValue());
        }
        return builder;
    }

    public static StringSchema.Builder merge(StringSchema.Builder builder, StringSchema s2) {
        SchemaUtils.copyGenericAttrs(builder, s2);
        if (s2.getMinLength() != null) {
            builder.minLength(s2.getMinLength());
        }
        if (s2.getMaxLength() != null) {
            builder.maxLength(s2.getMaxLength());
        }
        if (s2.getPattern() != null) {
            builder.pattern(s2.getPattern().pattern());
        }
        if (s2.requireString()) {
            builder.requiresString(true);
        }
        if (s2.getFormatValidator() != null) {
            builder.formatValidator(s2.getFormatValidator());
        }
        return builder;
    }

    public static TrueSchema.Builder merge(TrueSchema.Builder builder, TrueSchema s2) {
        SchemaUtils.copyGenericAttrs(builder, s2);
        return builder;
    }

    private static void copyGenericAttrs(Schema.Builder<?> builder, Schema s2) {
        if (s2.getTitle() != null) {
            builder.title(s2.getTitle());
        }
        if (s2.getDescription() != null) {
            builder.description(s2.getDescription());
        }
        if (s2.getId() != null) {
            builder.id(s2.getId());
        }
        if (s2.getDefaultValue() != null) {
            builder.defaultValue(s2.getDefaultValue());
        }
        if (s2.isNullable() != null) {
            builder.nullable(s2.isNullable());
        }
        if (s2.isReadOnly() != null) {
            builder.readOnly(s2.isReadOnly());
        }
        if (s2.isWriteOnly() != null) {
            builder.writeOnly(s2.isWriteOnly());
        }
        if (s2.getUnprocessedProperties() != null) {
            builder.unprocessedProperties(s2.getUnprocessedProperties());
        }
    }

    protected static boolean containsType(CombinedSchemaExt combinedSchema, Schema schema) {
        for (Schema subschema : combinedSchema.getSubschemas()) {
            if (!SchemaDiff.schemaTypesEqual(subschema, schema)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isGeneratedAll(Schema schema) {
        return schema instanceof CombinedSchemaExt && SchemaUtils.isGeneratedCombined((CombinedSchemaExt)schema, CombinedSchemaExt.ALL_CRITERION);
    }

    protected static boolean isGeneratedAny(Schema schema) {
        return schema instanceof CombinedSchemaExt && SchemaUtils.isGeneratedCombined((CombinedSchemaExt)schema, CombinedSchemaExt.ANY_CRITERION);
    }

    protected static boolean isGeneratedCombined(CombinedSchemaExt schema, CombinedSchema.ValidationCriterion criterion) {
        return schema.getCriterion() == criterion && schema.isGenerated();
    }
}

