/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(description="Config update request")
public class ConfigUpdateRequest {
    private String alias;
    private Boolean normalize;
    private Boolean validateFields;
    private Boolean validateRules;
    private String compatibilityLevel;
    private String compatibilityGroup;
    private Metadata defaultMetadata;
    private Metadata overrideMetadata;
    private RuleSet defaultRuleSet;
    private RuleSet overrideRuleSet;

    public ConfigUpdateRequest() {
    }

    public ConfigUpdateRequest(Config config) {
        this.alias = config.getAlias();
        this.normalize = config.isNormalize();
        this.validateFields = config.isValidateFields();
        this.validateRules = config.isValidateRules();
        this.compatibilityLevel = config.getCompatibilityLevel();
        this.compatibilityGroup = config.getCompatibilityGroup();
        this.defaultMetadata = config.getDefaultMetadata();
        this.overrideMetadata = config.getOverrideMetadata();
        this.defaultRuleSet = config.getDefaultRuleSet();
        this.overrideRuleSet = config.getOverrideRuleSet();
    }

    public static ConfigUpdateRequest fromJson(String json) throws IOException {
        return JacksonMapper.INSTANCE.readValue(json, ConfigUpdateRequest.class);
    }

    @JsonProperty(value="alias")
    public String getAlias() {
        return this.alias;
    }

    @JsonProperty(value="alias")
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @JsonProperty(value="normalize")
    public Boolean isNormalize() {
        return this.normalize;
    }

    @JsonProperty(value="normalize")
    public void setNormalize(Boolean normalize) {
        this.normalize = normalize;
    }

    @JsonProperty(value="validateFields")
    public Boolean isValidateFields() {
        return this.validateFields;
    }

    @JsonProperty(value="validateFields")
    public void setValidateFields(Boolean validateFields) {
        this.validateFields = validateFields;
    }

    @JsonProperty(value="validateRules")
    public Boolean isValidateRules() {
        return this.validateRules;
    }

    @JsonProperty(value="validateRules")
    public void setValidateRules(Boolean validateRules) {
        this.validateRules = validateRules;
    }

    @Schema(description="Compatibility Level", allowableValues={"BACKWARD", "BACKWARD_TRANSITIVE", "FORWARD", "FORWARD_TRANSITIVE", "FULL", "FULL_TRANSITIVE", "NONE"}, example="FULL_TRANSITIVE")
    @JsonProperty(value="compatibility")
    public String getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    @JsonProperty(value="compatibility")
    public void setCompatibilityLevel(String compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
    }

    @JsonProperty(value="compatibilityGroup")
    public String getCompatibilityGroup() {
        return this.compatibilityGroup;
    }

    @JsonProperty(value="compatibilityGroup")
    public void setCompatibilityGroup(String compatibilityGroup) {
        this.compatibilityGroup = compatibilityGroup;
    }

    @JsonProperty(value="defaultMetadata")
    public Metadata getDefaultMetadata() {
        return this.defaultMetadata;
    }

    @JsonProperty(value="defaultMetadata")
    public void setDefaultMetadata(Metadata defaultMetadata) {
        this.defaultMetadata = defaultMetadata;
    }

    @JsonProperty(value="overrideMetadata")
    public Metadata getOverrideMetadata() {
        return this.overrideMetadata;
    }

    @JsonProperty(value="overrideMetadata")
    public void setOverrideMetadata(Metadata overrideMetadata) {
        this.overrideMetadata = overrideMetadata;
    }

    @JsonProperty(value="defaultRuleSet")
    public RuleSet getDefaultRuleSet() {
        return this.defaultRuleSet;
    }

    @JsonProperty(value="defaultRuleSet")
    public void setDefaultRuleSet(RuleSet defaultRuleSet) {
        this.defaultRuleSet = defaultRuleSet;
    }

    @JsonProperty(value="overrideRuleSet")
    public RuleSet getOverrideRuleSet() {
        return this.overrideRuleSet;
    }

    @JsonProperty(value="overrideRuleSet")
    public void setOverrideRuleSet(RuleSet overrideRuleSet) {
        this.overrideRuleSet = overrideRuleSet;
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigUpdateRequest that = (ConfigUpdateRequest)o;
        return Objects.equals(this.alias, that.alias) && Objects.equals(this.normalize, that.normalize) && Objects.equals(this.validateFields, that.validateFields) && Objects.equals(this.validateRules, that.validateRules) && Objects.equals(this.compatibilityLevel, that.compatibilityLevel) && Objects.equals(this.compatibilityGroup, that.compatibilityGroup) && Objects.equals(this.defaultMetadata, that.defaultMetadata) && Objects.equals(this.overrideMetadata, that.overrideMetadata) && Objects.equals(this.defaultRuleSet, that.defaultRuleSet) && Objects.equals(this.overrideRuleSet, that.overrideRuleSet);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.normalize, this.validateFields, this.validateRules, this.compatibilityLevel, this.compatibilityGroup, this.defaultMetadata, this.overrideMetadata, this.defaultRuleSet, this.overrideRuleSet);
    }
}

