/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.formatter.SchemaMessageDeserializer;
import io.confluent.kafka.formatter.SchemaMessageFormatter;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.json.jackson.Jackson;
import io.confluent.kafka.serializers.json.AbstractKafkaJsonSchemaDeserializer;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class JsonSchemaMessageFormatter
extends SchemaMessageFormatter<JsonNode> {
    private static final ObjectMapper objectMapper = Jackson.newObjectMapper();

    public JsonSchemaMessageFormatter() {
    }

    JsonSchemaMessageFormatter(String url, Deserializer keyDeserializer) {
        super(url, keyDeserializer);
    }

    @Override
    protected SchemaMessageDeserializer<JsonNode> createDeserializer(Deserializer keyDeserializer) {
        return new JsonSchemaMessageDeserializer(keyDeserializer);
    }

    @Override
    protected void writeTo(String topic, Boolean isKey, Headers headers, byte[] data, PrintStream output) throws IOException {
        JsonNode object = (JsonNode)this.deserializer.deserialize(topic, isKey, headers, data);
        output.print(objectMapper.writeValueAsString(object));
    }

    @Override
    protected SchemaProvider getProvider() {
        return new JsonSchemaProvider();
    }

    static class JsonSchemaMessageDeserializer
    extends AbstractKafkaJsonSchemaDeserializer<JsonNode>
    implements SchemaMessageDeserializer<JsonNode> {
        protected final Deserializer keyDeserializer;

        JsonSchemaMessageDeserializer(Deserializer keyDeserializer) {
            this.keyDeserializer = keyDeserializer;
        }

        @Override
        public void configure(Map<String, ?> configs, boolean isKey) {
            if (!configs.containsKey("json.fail.invalid.schema")) {
                configs.put("json.fail.invalid.schema", "true");
            }
            this.configure(this.deserializerConfig(configs), null);
        }

        @Override
        public Deserializer getKeyDeserializer() {
            return this.keyDeserializer;
        }

        @Override
        public Object deserializeKey(String topic, Headers headers, byte[] payload) {
            return this.keyDeserializer.deserialize(topic, headers, payload);
        }

        @Override
        public JsonNode deserialize(String topic, Boolean isKey, Headers headers, byte[] payload) throws SerializationException {
            return (JsonNode)super.deserialize(false, topic, isKey, headers, payload);
        }

        @Override
        public SchemaRegistryClient getSchemaRegistryClient() {
            return this.schemaRegistry;
        }

        @Override
        public void close() throws IOException {
            if (this.keyDeserializer != null) {
                this.keyDeserializer.close();
            }
            super.close();
        }
    }
}

