/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.kotlinpoet;

import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B#\u0012\n\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\b\b\u0002\u0010\u0010\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006J\u0006\u0010\u0019\u001a\u00020\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0002J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\b\u0010\u001f\u001a\u00020\u0016H\u0002R\u0014\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/squareup/kotlinpoet/LineWrapper;", "Ljava/io/Closeable;", "out", "Lkotlin/text/Appendable;", "Ljava/lang/Appendable;", "indent", "", "columnLimit", "", "<init>", "(Ljava/lang/Appendable;Ljava/lang/String;I)V", "Ljava/lang/Appendable;", "closed", "", "segments", "", "indentLevel", "linePrefix", "hasPendingSegments", "getHasPendingSegments", "()Z", "append", "", "s", "appendNonWrapping", "newline", "close", "emitCurrentLine", "emitSegmentRange", "startIndex", "endIndex", "foldUnsafeBreaks", "Companion", "kotlinpoet"})
@SourceDebugExtension(value={"SMAP\nLineWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineWrapper.kt\ncom/squareup/kotlinpoet/LineWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1#2:177\n*E\n"})
public final class LineWrapper
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Appendable out;
    @NotNull
    private final String indent;
    private final int columnLimit;
    private boolean closed;
    @NotNull
    private final List<String> segments;
    private int indentLevel;
    @NotNull
    private String linePrefix;
    @NotNull
    private static final Regex UNSAFE_LINE_START = new Regex("\\s*[-+].*");
    @NotNull
    private static final char[] SPECIAL_CHARACTERS;

    public LineWrapper(@NotNull Appendable out, @NotNull String indent, int columnLimit) {
        Intrinsics.checkNotNullParameter(out, "out");
        Intrinsics.checkNotNullParameter(indent, "indent");
        this.out = out;
        this.indent = indent;
        this.columnLimit = columnLimit;
        String[] stringArray = new String[]{""};
        this.segments = CollectionsKt.mutableListOf(stringArray);
        this.indentLevel = -1;
        this.linePrefix = "";
    }

    public final boolean getHasPendingSegments() {
        return this.segments.size() != 1 || ((CharSequence)this.segments.get(0)).length() > 0;
    }

    public final void append(@NotNull String s2, int indentLevel, @NotNull String linePrefix) {
        Intrinsics.checkNotNullParameter(s2, "s");
        Intrinsics.checkNotNullParameter(linePrefix, "linePrefix");
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        int pos = 0;
        while (pos < s2.length()) {
            char c = s2.charAt(pos);
            if (c == ' ') {
                this.indentLevel = indentLevel;
                this.linePrefix = linePrefix;
                ((Collection)this.segments).add("");
                ++pos;
                continue;
            }
            if (c == '\n') {
                this.newline();
                ++pos;
                continue;
            }
            if (c == '\u00b7') {
                List<String> list = this.segments;
                int n = this.segments.size() - 1;
                list.set(n, list.get(n) + ' ');
                ++pos;
                continue;
            }
            int next = StringsKt.indexOfAny$default((CharSequence)s2, SPECIAL_CHARACTERS, pos, false, 4, null);
            if (next == -1) {
                next = s2.length();
            }
            List<String> list = this.segments;
            int n = this.segments.size() - 1;
            StringBuilder stringBuilder = new StringBuilder().append(list.get(n));
            String string = s2.substring(pos, next);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            list.set(n, stringBuilder.append(string).toString());
            pos = next;
        }
    }

    public static /* synthetic */ void append$default(LineWrapper lineWrapper, String string, int n, String string2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        lineWrapper.append(string, n, string2);
    }

    public final void appendNonWrapping(@NotNull String s2) {
        Intrinsics.checkNotNullParameter(s2, "s");
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        if (!(!StringsKt.contains$default((CharSequence)s2, "\n", false, 2, null))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        List<String> list = this.segments;
        int n = this.segments.size() - 1;
        list.set(n, list.get(n) + s2);
    }

    public final void newline() {
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        this.emitCurrentLine();
        this.out.append("\n");
        this.indentLevel = -1;
    }

    @Override
    public void close() {
        this.emitCurrentLine();
        this.closed = true;
    }

    private final void emitCurrentLine() {
        this.foldUnsafeBreaks();
        int start = 0;
        int columnCount = this.segments.get(0).length();
        int n = this.segments.size();
        for (int i = 1; i < n; ++i) {
            String segment = this.segments.get(i);
            int newColumnCount = columnCount + 1 + segment.length();
            if (newColumnCount > this.columnLimit) {
                this.emitSegmentRange(start, i);
                start = i;
                columnCount = segment.length() + this.indent.length() * this.indentLevel;
                continue;
            }
            columnCount = newColumnCount;
        }
        this.emitSegmentRange(start, this.segments.size());
        this.segments.clear();
        ((Collection)this.segments).add("");
    }

    private final void emitSegmentRange(int startIndex, int endIndex) {
        int i;
        if (startIndex > 0) {
            this.out.append("\n");
            int n = this.indentLevel;
            for (i = 0; i < n; ++i) {
                this.out.append(this.indent);
            }
            this.out.append(this.linePrefix);
        }
        this.out.append(this.segments.get(startIndex));
        for (i = startIndex + 1; i < endIndex; ++i) {
            this.out.append(" ");
            this.out.append(this.segments.get(i));
        }
    }

    private final void foldUnsafeBreaks() {
        int i = 1;
        while (i < this.segments.size()) {
            String segment = this.segments.get(i);
            if (UNSAFE_LINE_START.matches(segment)) {
                this.segments.set(i - 1, this.segments.get(i - 1) + ' ' + this.segments.get(i));
                this.segments.remove(i);
                if (i <= 1) continue;
                --i;
                continue;
            }
            ++i;
        }
    }

    static {
        char[] cArray = " \n\u00b7".toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
        SPECIAL_CHARACTERS = cArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/squareup/kotlinpoet/LineWrapper$Companion;", "", "<init>", "()V", "UNSAFE_LINE_START", "Lkotlin/text/Regex;", "SPECIAL_CHARACTERS", "", "kotlinpoet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

