/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.utility;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    static final Logger logger = LoggerFactory.getLogger(Util.class);
    public static final List<String> METHODS = Arrays.asList("GET", "HEAD", "POST", "PUT", "DELETE", "CONNECT", "OPTIONS", "TRACE", "PATCH");

    public static String quote(String value) {
        if (value == null) {
            return null;
        }
        Object result2 = value;
        if (!((String)result2).startsWith("\"")) {
            result2 = "\"" + (String)result2;
        }
        if (!((String)result2).endsWith("\"")) {
            result2 = (String)result2 + "\"";
        }
        return result2;
    }

    public static InetAddress getInetAddress() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (IOException ioe) {
            logger.error("Error in getting InetAddress", ioe);
        }
        return inetAddress;
    }

    public static String getJarVersion() {
        String path = Util.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        logger.debug("path = " + path);
        String ver = null;
        if (path.endsWith(".jar")) {
            int endIndex = path.indexOf(".jar");
            int startIndex = path.lastIndexOf("/");
            String jarName = path.substring(startIndex + 1, endIndex);
            ver = jarName.substring(jarName.lastIndexOf("-") + 1);
        }
        return ver;
    }

    public static String getFrameworkVersion() {
        Class<Util> clazz = Util.class;
        URL location = clazz.getResource("/" + clazz.getName().replace('.', '/') + ".class");
        System.out.println("location = " + String.valueOf(location));
        return location.toString();
    }

    public static int parseInteger(String intStr) {
        if (intStr == null) {
            return 0;
        }
        try {
            return Integer.parseInt(intStr);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static String urlEncode(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        try {
            return URLEncoder.encode(value, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String urlDecode(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        try {
            return URLDecoder.decode(value, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String substituteVariables(String template, Map<String, String> variables) {
        Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher matcher = pattern.matcher(template);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            if (!variables.containsKey(matcher.group(1))) continue;
            String replacement = variables.get(matcher.group(1));
            matcher.appendReplacement(buffer, replacement != null ? Matcher.quoteReplacement(replacement) : "null");
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static Map<String, String> parseAttributes(String attributesString) {
        String[] pairs;
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        if (attributesString == null || attributesString.trim().isEmpty()) {
            return attributeMap;
        }
        for (String pair : pairs = attributesString.split("~")) {
            String[] keyValue = pair.split("\\^=\\^", 2);
            if (keyValue.length != 2) continue;
            String key = keyValue[0];
            String value = keyValue[1];
            attributeMap.put(key, value);
        }
        return attributeMap;
    }

    public static String getServiceId(Map<String, Object> jsonMap) {
        return (String)(jsonMap.get("host") == null ? "" : String.valueOf(jsonMap.get("host")) + "/") + (String)(jsonMap.get("service") == null ? "" : String.valueOf(jsonMap.get("service")) + "/") + (String)(jsonMap.get("action") == null ? "" : String.valueOf(jsonMap.get("action")) + "/") + String.valueOf(jsonMap.get("version") == null ? "" : jsonMap.get("version"));
    }

    public static String getServiceId(String host, String service, String name2, String version) {
        return (String)(host == null ? "" : host + "/") + (String)(service == null ? "" : service + "/") + (String)(name2 == null ? "" : name2 + "/") + (version == null ? "" : version);
    }
}

