/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.server;

import com.networknt.config.Config;
import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.ConfigSchema;
import com.networknt.config.schema.Format;
import com.networknt.config.schema.IntegerField;
import com.networknt.config.schema.OutputFormat;
import com.networknt.config.schema.StringField;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigSchema(configKey="server", configName="server", outputFormats={OutputFormat.JSON_SCHEMA, OutputFormat.YAML})
public class ServerConfig {
    public static Logger logger = LoggerFactory.getLogger(ServerConfig.class);
    public static final String CONFIG_NAME = "server";
    public static final String IP = "ip";
    public static final String HTTP_PORT = "httpPort";
    public static final String ENABLE_HTTP = "enableHttp";
    public static final String HTTPS_PORT = "httpsPort";
    public static final String ENABLE_HTTPS = "enableHttps";
    public static final String ENABLE_HTTP2 = "enableHttp2";
    public static final String KEYSTORE_NAME = "keystoreName";
    public static final String KEYSTORE_PASS = "keystorePass";
    public static final String KEY_PASS = "keyPass";
    public static final String ENABLE_TWO_WAY_TLS = "enableTwoWayTls";
    public static final String TRUSTSTORE_NAME = "truststoreName";
    public static final String TRUSTSTORE_PASS = "truststorePass";
    public static final String ENABLE_REGISTRY = "enableRegistry";
    public static final String SERVICE_ID = "serviceId";
    public static final String SERVICE_NAME = "serviceName";
    public static final String ENVIRONMENT = "environment";
    public static final String BUILD_NUMBER = "buildNumber";
    public static final String DYNAMIC_PORT = "dynamicPort";
    public static final String MIN_PORT = "minPort";
    public static final String MAX_PORT = "maxPort";
    public static final String BUFFER_SIZE = "bufferSize";
    public static final String IO_THREADS = "ioThreads";
    public static final String WORKER_THREADS = "workerThreads";
    public static final String BACKLOG = "backlog";
    public static final String SHUTDOWN_TIMEOUT = "shutdownTimeout";
    public static final String SHUTDOWN_GRACEFUL_PERIOD = "shutdownGracefulPeriod";
    public static final String ALWAYS_SET_DATE = "alwaysSetDate";
    public static final String ALLOW_UNESCAPED_CHARACTERS_IN_URL = "allowUnescapedCharactersInUrl";
    public static final String SERVER_STRING = "serverString";
    public static final String BOOTSTRAP_STORE_NAME = "bootstrapStoreName";
    public static final String BOOTSTRAP_STORE_PASS = "bootstrapStorePass";
    public static final String MAX_TRANSFER_FILE_SIZE = "maxTransferFileSize";
    public static final String START_ON_REGISTRY_FAILURE = "startOnRegistryFailure";
    public static final String MASK_CONFIG_PROPERTIES = "maskConfigProperties";
    @StringField(configFieldName="ip", externalizedKeyName="ip", externalized=true, description="This is the default binding address if the service is dockerized.")
    String ip;
    @IntegerField(configFieldName="httpPort", externalizedKeyName="httpPort", externalized=true, description="Http port if enableHttp is true. It will be ignored if dynamicPort is true.")
    int httpPort;
    @BooleanField(configFieldName="enableHttp", externalizedKeyName="enableHttp", externalized=true, description="Enable HTTP should be false by default. It should be only used for testing with clients or tools\nthat don't support https or very hard to import the certificate. Otherwise, https should be used.\nWhen enableHttp, you must set enableHttps to false, otherwise, this flag will be ignored. There is\nonly one protocol will be used for the server at anytime. If both http and https are true, only\nhttps listener will be created and the server will bind to https port only.")
    boolean enableHttp;
    @IntegerField(configFieldName="httpsPort", externalizedKeyName="httpsPort", externalized=true, description="Https port if enableHttps is true. It will be ignored if dynamicPort is true.")
    int httpsPort;
    @BooleanField(configFieldName="enableHttps", externalizedKeyName="enableHttps", externalized=true, description="Enable HTTPS should be true on official environment and most dev environments.")
    boolean enableHttps;
    @BooleanField(configFieldName="enableHttps", externalizedKeyName="enableHttp2", externalized=true, description="Http/2 is enabled by default for better performance and it works with the client module\nPlease note that HTTP/2 only works with HTTPS.")
    boolean enableHttp2;
    @StringField(configFieldName="keystoreName", externalizedKeyName="keystoreName", externalized=true, description="Keystore file name in config folder.")
    String keystoreName;
    @StringField(configFieldName="keystorePass", externalizedKeyName="keystorePass", externalized=true, description="Keystore password")
    String keystorePass;
    @StringField(configFieldName="keyPass", externalizedKeyName="keyPass", externalized=true, description="Private key password")
    String keyPass;
    @BooleanField(configFieldName="enableTwoWayTls", externalizedKeyName="enableTwoWayTls", externalized=true, description="Flag that indicate if two way TLS is enabled. Not recommended in docker container.")
    boolean enableTwoWayTls;
    @StringField(configFieldName="truststoreName", externalizedKeyName="truststoreName", externalized=true, description="Truststore file name in config folder.")
    String truststoreName;
    @StringField(configFieldName="truststorePass", externalizedKeyName="truststorePass", externalized=true, description="Truststore password")
    String truststorePass;
    @StringField(configFieldName="bootstrapStoreName", externalizedKeyName="ip", externalized=true, description="Bootstrap truststore name used to connect to the light-config-server if it is used.")
    String bootstrapStoreName;
    @StringField(configFieldName="bootstrapStorePass", externalizedKeyName="bootstrapStorePass", externalized=true, description="Bootstrap truststore password")
    String bootstrapStorePass;
    @StringField(configFieldName="serviceId", externalizedKeyName="serviceId", externalized=true, description="Unique service identifier. Used in service registration and discovery etc.")
    String serviceId;
    @BooleanField(configFieldName="enableRegistry", externalizedKeyName="enableRegistry", externalized=true, description="Flag to enable self service registration. This should be turned on on official test and production. And\ndyanmicPort should be enabled if any orchestration tool is used like Kubernetes.")
    boolean enableRegistry;
    @BooleanField(configFieldName="startOnRegistryFailure", externalizedKeyName="startOnRegistryFailure", externalized=true, description="When enableRegistry is true and the registry/discovery service is not reachable. Stop the server or continue\nstarting the server. When your global registry is not setup as high availability and only for monitoring, you\ncan set it true. If you are using it for global service discovery, leave it with false.")
    boolean startOnRegistryFailure;
    @BooleanField(configFieldName="dynamicPort", externalizedKeyName="dynamicPort", externalized=true, description="Dynamic port is used in situation that multiple services will be deployed on the same host and normally\nyou will have enableRegistry set to true so that other services can find the dynamic port service. When\ndeployed to Kubernetes cluster, the Pod must be annotated as hostNetwork: true")
    boolean dynamicPort;
    @IntegerField(configFieldName="minPort", externalizedKeyName="minPort", externalized=true, description="Minimum port range. This define a range for the dynamic allocated ports so that it is easier to setup\nfirewall rule to enable this range. Default 2400 to 2500 block has 100 port numbers and should be\nenough for most cases unless you are using a big bare metal box as Kubernetes node that can run 1000s pods")
    int minPort;
    @IntegerField(configFieldName="maxPort", externalizedKeyName="maxPort", externalized=true, description="Maximum port rang. The range can be customized to adopt your network security policy and can be increased or\nreduced to ease firewall rules.")
    int maxPort;
    @StringField(configFieldName="environment", externalizedKeyName="environment", externalized=true, description="environment tag that will be registered on consul to support multiple instances per env for testing.\nhttps://github.com/networknt/light-doc/blob/master/docs/content/design/env-segregation.md\nThis tag should only be set for testing env, not production. The production certification process will enforce it.")
    String environment;
    @StringField(configFieldName="buildNumber", externalizedKeyName="buildNumber", externalized=true, description="Build Number, to be set by teams for auditing or tracing purposes.\nAllows teams to audit the value and set it according to their release management process")
    String buildNumber;
    @IntegerField(configFieldName="shutdownGracefulPeriod", externalizedKeyName="shutdownGracefulPeriod", externalized=true, description="Shutdown gracefully wait period in milliseconds\nIn this period, it allows the in-flight requests to complete but new requests are not allowed. It needs to be set\nbased on the slowest request possible.")
    int shutdownGracefulPeriod;
    @StringField(configFieldName="serviceName", externalizedKeyName="serviceName", externalized=true, description="The following parameters are for advanced users to fine tune the service in a container environment. Please leave\nthese values default if you do not understand. For more info, visit https://doc.networknt.com/concern/server/\n\nUnique service name. Used in microservice to associate a given name to a service with configuration\nor as a key within the configuration of a particular domain")
    String serviceName;
    @IntegerField(configFieldName="bufferSize", externalizedKeyName="bufferSize", externalized=true, description="Buffer size of undertow server. Default to 16K")
    int bufferSize;
    @IntegerField(configFieldName="ioThreads", externalizedKeyName="ioThreads", externalized=true, description="Number of IO thread. Default to number of processor * 2")
    int ioThreads;
    @IntegerField(configFieldName="workerThreads", externalizedKeyName="workerThreads", externalized=true, description="Number of worker threads. Default to 200 and it can be reduced to save memory usage in a container with only one cpu")
    int workerThreads;
    @IntegerField(configFieldName="backlog", externalizedKeyName="backlog", externalized=true, description="Backlog size. Default to 10000")
    int backlog;
    @BooleanField(configFieldName="alwaysSetDate", externalizedKeyName="alwaysSetDate", externalized=true, description="Flag to set UndertowOptions.ALWAYS_SET_DATE")
    boolean alwaysSetDate;
    @StringField(configFieldName="serverString", externalizedKeyName="serverString", externalized=true, description="Server string used to mark the server. Default to L for light-4j.")
    String serverString;
    @IntegerField(configFieldName="shutdownTimeout", externalizedKeyName="shutdownTimeout", externalized=true, description="")
    int shutdownTimeout;
    @BooleanField(configFieldName="allowUnescapedCharactersInUrl", externalizedKeyName="allowUnescapedCharactersInUrl", externalized=true, description="Flag to set UndertowOptions.ALLOW_UNESCAPED_CHARACTERS_IN_URL. Default to false.\nPlease note that this option widens the attack surface and attacker can potentially access your filesystem.\nThis should only be used on an internal server and never be used on a server accessed from the Internet.")
    boolean allowUnescapedCharactersInUrl;
    @IntegerField(configFieldName="maxTransferFileSize", externalizedKeyName="maxTransferFileSize", externalized=true, description="Set the max transfer file size for uploading files. Default to 1000000 which is 1 MB.", format=Format.u64)
    long maxTransferFileSize;
    @BooleanField(configFieldName="maskConfigProperties", externalizedKeyName="maskConfigProperties", externalized=true, description="Indicate if the mask for the module registry should be applied or not. Default to true. If all the sensitive\nproperties are encrypted, then this flag can be set to false. This allows the encrypted sensitive properties\nto show up in the server info response. When config server is used, this flag should be set to false so that\nthe server info response can be automatically compared with the config server generated server info based on\nthe config properties.")
    boolean maskConfigProperties;
    private final Config config = Config.getInstance();
    private final Map<String, Object> mappedConfig;
    private static volatile ServerConfig instance;

    private ServerConfig() {
        this.mappedConfig = this.config.getJsonMapConfig(CONFIG_NAME);
        this.load();
    }

    private ServerConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.load();
    }

    private void load() {
        if (this.mappedConfig != null) {
            Object object = this.mappedConfig.get(IP);
            if (object != null) {
                this.ip = (String)object;
            }
            if ((object = this.mappedConfig.get(HTTP_PORT)) != null) {
                this.httpPort = Config.loadIntegerValue(HTTP_PORT, object);
            }
            if ((object = this.mappedConfig.get(ENABLE_HTTP)) != null) {
                this.enableHttp = Config.loadBooleanValue(ENABLE_HTTP, object);
            }
            if ((object = this.mappedConfig.get(HTTPS_PORT)) != null) {
                this.httpsPort = Config.loadIntegerValue(HTTPS_PORT, object);
            }
            if ((object = this.mappedConfig.get(ENABLE_HTTPS)) != null) {
                this.enableHttps = Config.loadBooleanValue(ENABLE_HTTPS, object);
            }
            if ((object = this.mappedConfig.get(ENABLE_HTTP2)) != null) {
                this.enableHttp2 = Config.loadBooleanValue(ENABLE_HTTP2, object);
            }
            if ((object = this.mappedConfig.get(KEYSTORE_NAME)) != null) {
                this.keystoreName = (String)object;
            }
            if ((object = this.mappedConfig.get(KEYSTORE_PASS)) != null) {
                this.keystorePass = (String)object;
            }
            if ((object = this.mappedConfig.get(KEY_PASS)) != null) {
                this.keyPass = (String)object;
            }
            if ((object = this.mappedConfig.get(ENABLE_TWO_WAY_TLS)) != null) {
                this.enableTwoWayTls = Config.loadBooleanValue(ENABLE_TWO_WAY_TLS, object);
            }
            if ((object = this.mappedConfig.get(TRUSTSTORE_NAME)) != null) {
                this.truststoreName = (String)object;
            }
            if ((object = this.mappedConfig.get(TRUSTSTORE_PASS)) != null) {
                this.truststorePass = (String)object;
            }
            if ((object = this.mappedConfig.get(ENABLE_REGISTRY)) != null) {
                this.enableRegistry = Config.loadBooleanValue(ENABLE_REGISTRY, object);
            }
            if ((object = this.mappedConfig.get(SERVICE_ID)) != null) {
                this.serviceId = (String)object;
            }
            if ((object = this.mappedConfig.get(SERVICE_NAME)) != null) {
                this.serviceName = (String)object;
            }
            if ((object = this.mappedConfig.get(ENVIRONMENT)) != null) {
                this.environment = (String)object;
            }
            if ((object = this.mappedConfig.get(BUILD_NUMBER)) != null) {
                this.buildNumber = (String)object;
            }
            if ((object = this.mappedConfig.get(DYNAMIC_PORT)) != null) {
                this.dynamicPort = Config.loadBooleanValue(DYNAMIC_PORT, object);
            }
            if ((object = this.mappedConfig.get(MIN_PORT)) != null) {
                this.minPort = Config.loadIntegerValue(MIN_PORT, object);
            }
            if ((object = this.mappedConfig.get(MAX_PORT)) != null) {
                this.maxPort = Config.loadIntegerValue(MAX_PORT, object);
            }
            if ((object = this.mappedConfig.get(BUFFER_SIZE)) != null) {
                this.bufferSize = Config.loadIntegerValue(BUFFER_SIZE, object);
            }
            if ((object = this.mappedConfig.get(IO_THREADS)) != null) {
                this.ioThreads = Config.loadIntegerValue(IO_THREADS, object);
            }
            if ((object = this.mappedConfig.get(WORKER_THREADS)) != null) {
                this.workerThreads = Config.loadIntegerValue(WORKER_THREADS, object);
            }
            if ((object = this.mappedConfig.get(BACKLOG)) != null) {
                this.backlog = Config.loadIntegerValue(BACKLOG, object);
            }
            if ((object = this.mappedConfig.get(SHUTDOWN_TIMEOUT)) != null) {
                this.shutdownTimeout = Config.loadIntegerValue(SHUTDOWN_TIMEOUT, object);
            }
            if ((object = this.mappedConfig.get(SHUTDOWN_GRACEFUL_PERIOD)) != null) {
                this.shutdownGracefulPeriod = Config.loadIntegerValue(SHUTDOWN_GRACEFUL_PERIOD, object);
            }
            if ((object = this.mappedConfig.get(ALWAYS_SET_DATE)) != null) {
                this.alwaysSetDate = Config.loadBooleanValue(ALWAYS_SET_DATE, object);
            }
            if ((object = this.mappedConfig.get(ALLOW_UNESCAPED_CHARACTERS_IN_URL)) != null) {
                this.allowUnescapedCharactersInUrl = Config.loadBooleanValue(ALLOW_UNESCAPED_CHARACTERS_IN_URL, object);
            }
            if ((object = this.mappedConfig.get(SERVER_STRING)) != null) {
                this.serverString = (String)object;
            }
            if ((object = this.mappedConfig.get(BOOTSTRAP_STORE_NAME)) != null) {
                this.bootstrapStoreName = (String)object;
            }
            if ((object = this.mappedConfig.get(BOOTSTRAP_STORE_PASS)) != null) {
                this.bootstrapStorePass = (String)object;
            }
            if ((object = this.mappedConfig.get(MAX_TRANSFER_FILE_SIZE)) != null) {
                this.maxTransferFileSize = Config.loadLongValue(MAX_TRANSFER_FILE_SIZE, object);
            }
            if ((object = this.mappedConfig.get(START_ON_REGISTRY_FAILURE)) != null) {
                this.startOnRegistryFailure = Config.loadBooleanValue(START_ON_REGISTRY_FAILURE, object);
            }
            if ((object = this.mappedConfig.get(MASK_CONFIG_PROPERTIES)) != null) {
                this.maskConfigProperties = Config.loadBooleanValue(MASK_CONFIG_PROPERTIES, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerConfig getInstance() {
        if (instance != null) return instance;
        Class<ServerConfig> clazz = ServerConfig.class;
        synchronized (ServerConfig.class) {
            if (instance != null) return instance;
            instance = new ServerConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static ServerConfig getInstance(String configName) {
        instance = new ServerConfig(configName);
        return instance;
    }

    public static ServerConfig get(String configName) {
        instance = new ServerConfig(configName);
        return instance;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getHttpPort() {
        String port = System.getProperty(HTTP_PORT);
        if (port != null) {
            try {
                int newPort;
                this.httpPort = newPort = Integer.parseInt(port);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace(System.err);
            }
        }
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public boolean isEnableHttp() {
        return this.enableHttp;
    }

    public void setEnableHttp(boolean enableHttp) {
        this.enableHttp = enableHttp;
    }

    public int getHttpsPort() {
        String port = System.getProperty(HTTPS_PORT);
        if (port != null) {
            try {
                int newPort;
                this.httpsPort = newPort = Integer.parseInt(port);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace(System.err);
            }
        }
        return this.httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public boolean isEnableHttps() {
        return this.enableHttps;
    }

    public void setEnableHttps(boolean enableHttps) {
        this.enableHttps = enableHttps;
    }

    public String getKeystoreName() {
        return this.keystoreName;
    }

    public void setKeystoreName(String keystoreName) {
        this.keystoreName = keystoreName;
    }

    public String getTruststoreName() {
        return this.truststoreName;
    }

    public void setTruststoreName(String truststoreName) {
        this.truststoreName = truststoreName;
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public void setKeystorePass(String keystorePass) {
        this.keystorePass = keystorePass;
    }

    public String getKeyPass() {
        return this.keyPass;
    }

    public void setKeyPass(String keyPass) {
        this.keyPass = keyPass;
    }

    public String getTruststorePass() {
        return this.truststorePass;
    }

    public void setTruststorePass(String truststorePass) {
        this.truststorePass = truststorePass;
    }

    public boolean isEnableTwoWayTls() {
        return this.enableTwoWayTls;
    }

    public void setEnableTwoWayTls(boolean enableTwoWayTls) {
        this.enableTwoWayTls = enableTwoWayTls;
    }

    public boolean isEnableRegistry() {
        return this.enableRegistry;
    }

    public void setEnableRegistry(boolean enableRegistry) {
        this.enableRegistry = enableRegistry;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public boolean isEnableHttp2() {
        return this.enableHttp2;
    }

    public void setEnableHttp2(boolean enableHttp2) {
        this.enableHttp2 = enableHttp2;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment2) {
        this.environment = environment2;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public boolean isDynamicPort() {
        return this.dynamicPort;
    }

    public void setDynamicPort(boolean dynamicPort) {
        this.dynamicPort = dynamicPort;
    }

    public int getMinPort() {
        return this.minPort;
    }

    public void setMinPort(int minPort) {
        this.minPort = minPort;
    }

    public int getMaxPort() {
        return this.maxPort;
    }

    public void setMaxPort(int maxPort) {
        this.maxPort = maxPort;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getIoThreads() {
        return this.ioThreads;
    }

    public void setIoThreads(int ioThreads) {
        this.ioThreads = ioThreads;
    }

    public int getWorkerThreads() {
        return this.workerThreads;
    }

    public void setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public int getShutdownGracefulPeriod() {
        return this.shutdownGracefulPeriod;
    }

    public void setShutdownGracefulPeriod(int shutdownGracefulPeriod) {
        this.shutdownGracefulPeriod = shutdownGracefulPeriod;
    }

    public boolean isAlwaysSetDate() {
        return this.alwaysSetDate;
    }

    public void setAlwaysSetDate(boolean alwaysSetDate) {
        this.alwaysSetDate = alwaysSetDate;
    }

    public String getServerString() {
        return this.serverString;
    }

    public void setServerString(String serverString) {
        this.serverString = serverString;
    }

    public boolean isAllowUnescapedCharactersInUrl() {
        return this.allowUnescapedCharactersInUrl;
    }

    public void setAllowUnescapedCharactersInUrl(boolean allowUnescapedCharactersInUrl) {
        this.allowUnescapedCharactersInUrl = allowUnescapedCharactersInUrl;
    }

    public String getBootstrapStoreName() {
        return this.bootstrapStoreName;
    }

    public void setBootstrapStoreName(String bootstrapStoreName) {
        this.bootstrapStoreName = bootstrapStoreName;
    }

    public String getBootstrapStorePass() {
        return this.bootstrapStorePass;
    }

    public void setBootstrapStorePass(String bootstrapStorePass) {
        this.bootstrapStorePass = bootstrapStorePass;
    }

    public long getMaxTransferFileSize() {
        return this.maxTransferFileSize;
    }

    public void setMaxTransferFileSize(long maxTransferFileSize) {
        this.maxTransferFileSize = maxTransferFileSize;
    }

    public boolean isStartOnRegistryFailure() {
        return this.startOnRegistryFailure;
    }

    public void setStartOnRegistryFailure(boolean startOnRegistryFailure) {
        this.startOnRegistryFailure = startOnRegistryFailure;
    }

    public boolean isMaskConfigProperties() {
        return this.maskConfigProperties;
    }

    public void setMaskConfigProperties(boolean maskConfigProperties) {
        this.maskConfigProperties = maskConfigProperties;
    }
}

