/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.security;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.networknt.config.schema.IntegerField;
import com.networknt.config.schema.MapField;
import com.networknt.config.schema.StringField;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class SecurityJwtConfig {
    private static final String CLOCK_SKEW_IN_SECONDS = "clockSkewInSeconds";
    private static final String KEY_RESOLVER = "keyResolver";
    private static final String CERTIFICATE = "certificate";
    @IntegerField(configFieldName="clockSkewInSeconds", externalizedKeyName="clockSkewInSeconds", externalized=true)
    private int clockSkewInSeconds;
    @MapField(configFieldName="certificate", externalizedKeyName="certificate", externalized=true, defaultValue="100=primary.crt&101=secondary.crt", valueType=String.class)
    @JsonDeserialize(using=CertificateDeserializer.class)
    private Map<String, Object> certificate;
    @StringField(configFieldName="keyResolver", externalizedKeyName="keyResolver", externalized=true, description="Key distribution server standard: JsonWebKeySet for other OAuth 2.0 provider| X509Certificate for light-oauth2")
    private String keyResolver;

    public int getClockSkewInSeconds() {
        return this.clockSkewInSeconds;
    }

    public Map<String, Object> getCertificate() {
        return this.certificate;
    }

    public String getKeyResolver() {
        return this.keyResolver;
    }

    private static class CertificateDeserializer
    extends JsonDeserializer<Map<String, Object>> {
        private CertificateDeserializer() {
        }

        @Override
        public Map<String, Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
            ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
            JsonNode root = (JsonNode)mapper.readTree(jsonParser);
            if (root.isObject()) {
                return mapper.convertValue((Object)root, new TypeReference<Map<String, Object>>(){});
            }
            if (root.isTextual()) {
                String s2 = mapper.convertValue((Object)root, String.class);
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                for (String keyValue : s2.split(" *& *")) {
                    String[] pairs = keyValue.split(" *= *", 2);
                    map.put(pairs[0], pairs.length == 1 ? "" : pairs[1]);
                }
                return map;
            }
            return Map.of();
        }
    }
}

