/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.security;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import com.networknt.config.schema.ArrayField;
import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.ConfigSchema;
import com.networknt.config.schema.IntegerField;
import com.networknt.config.schema.MapField;
import com.networknt.config.schema.ObjectField;
import com.networknt.config.schema.OutputFormat;
import com.networknt.config.schema.StringField;
import com.networknt.security.SecurityJwtConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigSchema(configName="security", configKey="security", outputFormats={OutputFormat.JSON_SCHEMA, OutputFormat.YAML})
public class SecurityConfig {
    public static final String CONFIG_NAME = "security";
    private static final Logger logger = LoggerFactory.getLogger(SecurityConfig.class);
    private static final String ENABLE_VERIFY_JWT = "enableVerifyJwt";
    private static final String ENABLE_VERIFY_SWT = "enableVerifySwt";
    private static final String SWT_CLIENT_ID_HEADER = "swtClientIdHeader";
    private static final String SWT_CLIENT_SECRET_HEADER = "swtClientSecretHeader";
    private static final String ENABLE_EXTRACT_SCOPE_TOKEN = "enableExtractScopeToken";
    private static final String ENABLE_VERIFY_SCOPE = "enableVerifyScope";
    private static final String SKIP_VERIFY_SCOPE_WITHOUT_SPEC = "skipVerifyScopeWithoutSpec";
    private static final String ENABLE_MOCK_JWT = "enableMockJwt";
    private static final String JWT = "jwt";
    private static final String CERTIFICATE = "certificate";
    private static final String CLOCK_SKEW_IN_SECONDS = "clockSkewInSeconds";
    private static final String KEY_RESOLVER = "keyResolver";
    private static final String LOG_JWT_TOKEN = "logJwtToken";
    private static final String LOG_CLIENT_USER_SCOPE = "logClientUserScope";
    private static final String ENABLE_JWT_CACHE = "enableJwtCache";
    private static final String JWT_CACHE_FULL_SIZE = "jwtCacheFullSize";
    private static final String BOOTSTRAP_FROM_KEY_SERVICE = "bootstrapFromKeyService";
    private static final String IGNORE_JWT_EXPIRY = "ignoreJwtExpiry";
    private static final String PROVIDER_ID = "providerId";
    private static final String ENABLE_H2C = "enableH2c";
    private static final String ENABLE_RELAXED_KEY_CONSTRAINTS = "enableRelaxedKeyValidation";
    private static final String SKIP_PATH_PREFIXES = "skipPathPrefixes";
    private static final String PASS_THROUGH_CLAIMS = "passThroughClaims";
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();
    @BooleanField(configFieldName="enableVerifyJwt", externalizedKeyName="enableVerifyJwt", externalized=true, defaultValue=true, description="Enable the JWT verification flag. The JwtVerifierHandler will skip the JWT token verification\nif this flag is false. It should only be set to false on the dev environment for testing\npurposes. If you have some endpoints that want to skip the JWT verification, you can put the\nrequest path prefix in skipPathPrefixes.")
    private boolean enableVerifyJwt;
    @BooleanField(configFieldName="enableVerifySwt", externalizedKeyName="enableVerifySwt", externalized=true, defaultValue=true, description="Enable the SWT verification flag. The SwtVerifierHandler will skip the SWT token verification\nif this flag is false. It should only be set to false on the dev environment for testing\npurposes. If you have some endpoints that want to skip the SWT verification, you can put the\nrequest path prefix in skipPathPrefixes.")
    private boolean enableVerifySwt;
    @StringField(configFieldName="swtClientIdHeader", externalizedKeyName="swtClientIdHeader", externalized=true, defaultValue="swt-client", description="swt clientId header name. When light-gateway is used and the consumer app does not want to save\nthe client secret in the configuration file, it can be passed in the header.")
    private String swtClientIdHeader;
    @StringField(configFieldName="swtClientSecretHeader", externalizedKeyName="swtClientSecretHeader", externalized=true, defaultValue="swt_secret", description="swt clientSecret header name. When light-gateway is used and the consumer app does not want to save\nthe client secret in the configuration file, it can be passed in the header.")
    private String swtClientSecretHeader;
    @BooleanField(configFieldName="enableExtractScopeToken", externalizedKeyName="enableExtractScopeToken", externalized=true, defaultValue=true, description="Extract JWT scope token from the X-Scope-Token header and validate the JWT token")
    private boolean enableExtractScopeToken;
    @BooleanField(configFieldName="enableVerifyScope", externalizedKeyName="enableVerifyScope", externalized=true, defaultValue=true, description="Enable JWT scope verification. This flag is valid when enableVerifyJwt is true. When using the\nlight gateway as a centralized gateway without backend API specifications, you can still enable\nthis flag to allow the admin endpoints to have scopes verified. And all backend APIs without\nspecifications skip the scope verification if the spec does not exist with the skipVerifyScopeWithoutSpec\nflag to true. Also, you need to have the openapi.yml specification file in the config folder to\nenable it, as the scope verification compares the scope from the JWT token and the scope in the\nendpoint specification.")
    private boolean enableVerifyScope;
    @BooleanField(configFieldName="skipVerifyScopeWithoutSpec", externalizedKeyName="skipVerifyScopeWithoutSpec", externalized=true, description="Users should only use this flag in a shared light gateway if the backend API specifications are\nunavailable in the gateway config folder. If this flag is true and the enableVerifyScope is true,\nthe security handler will invoke the scope verification for all endpoints. However, if the endpoint\ndoesn't have a specification to retrieve the defined scopes, the handler will skip the scope verification.")
    private boolean skipVerifyScopeWithoutSpec;
    @BooleanField(configFieldName="ignoreJwtExpiry", externalizedKeyName="ignoreJwtExpiry", externalized=true, description="If set true, the JWT verifier handler will pass if the JWT token is expired already. Unless\nyou have a strong reason, please use it only on the dev environment if your OAuth 2 provider\ndoesn't support long-lived token for dev environment or test automation.")
    private boolean ignoreJwtExpiry;
    @BooleanField(configFieldName="enableH2c", externalizedKeyName="enableH2c", externalized=true, defaultValue=true, description="set true if you want to allow http 1/1 connections to be upgraded to http/2 using the UPGRADE method (h2c).\nBy default, this is set to false for security reasons. If you choose to enable it make sure you can handle http/2 w/o tls.")
    private boolean enableH2c;
    @BooleanField(configFieldName="enableMockJwt", externalizedKeyName="enableMockJwt", externalized=true, description="User for test only. should be always be false on official environment.")
    private boolean enableMockJwt;
    @BooleanField(configFieldName="enableRelaxedKeyValidation", externalizedKeyName="enableRelaxedKeyValidation", externalized=true, defaultValue=true, description="")
    private boolean enableRelaxedKeyValidation;
    @ObjectField(configFieldName="jwt", description="JWT signature public certificates. kid and certificate path mappings.", ref=SecurityJwtConfig.class, useSubObjectDefault=true)
    private SecurityJwtConfig jwt;
    @BooleanField(configFieldName="logJwtToken", externalizedKeyName="logJwtToken", externalized=true, defaultValue=true, description="Enable or disable JWT token logging for audit. This is to log the entire token\nor choose the next option that only logs client_id, user_id and scope.")
    private boolean logJwtToken;
    @BooleanField(configFieldName="logClientUserScope", externalizedKeyName="logClientUserScope", externalized=true, defaultValue=true, description="Enable or disable client_id, user_id and scope logging if you don't want to log\nthe entire token. Choose this option or the option above.")
    private boolean logClientUserScope;
    @BooleanField(configFieldName="enableJwtCache", externalizedKeyName="enableJwtCache", externalized=true, defaultValue=true, description="Enable JWT token cache to speed up verification. This will only verify expired time\nand skip the signature verification as it takes more CPU power and a long time. If\neach request has a different jwt token, like authorization code flow, this indicator\nshould be turned off. Otherwise, the cached jwt will only be removed after 15 minutes\nand the cache can grow bigger if the number of requests is very high. This will cause\nmemory kill in a Kubernetes pod if the memory setting is limited.")
    private boolean enableJwtCache;
    @IntegerField(configFieldName="jwtCacheFullSize", externalizedKeyName="jwtCacheFullSize", externalized=true, description="If enableJwtCache is true, then an error message will be shown up in the log if the\ncache size is bigger than the jwtCacheFullSize. This helps the developers to detect\ncache problem if many distinct tokens flood the cache in a short period of time. If\nyou see JWT cache exceeds the size limit in logs, you need to turn off the enableJwtCache\nor increase the cache full size to a bigger number from the default 100.")
    private int jwtCacheFullSize;
    @BooleanField(configFieldName="bootstrapFromKeyService", externalizedKeyName="bootstrapFromKeyService", externalized=true, defaultValue=true, description="If you are using light-oauth2, then you don't need to have oauth subfolder for public\nkey certificate to verify JWT token, the key will be retrieved from key endpoint once\nthe first token is arrived. Default to false for dev environment without oauth2 server\nor official environment that use other OAuth 2.0 providers.")
    private boolean bootstrapFromKeyService;
    @StringField(configFieldName="providerId", externalizedKeyName="providerId", externalized=true, description="Used in light-oauth2 and oauth-kafka key service for federated deployment. Each instance\nwill have a providerId, and it will be part of the kid to allow each instance to get the\nJWK from other instance based on the providerId in the kid.")
    private String providerId;
    @ArrayField(configFieldName="skipPathPrefixes", externalizedKeyName="skipPathPrefixes", externalized=true, description="Define a list of path prefixes to skip the security to ease the configuration for the\nhandler.yml so that users can define some endpoint without security even through it uses\nthe default chain. This is particularly useful in the light-gateway use case as the same\ninstance might be shared with multiple consumers and providers with different security\nrequirement. The format is a list of strings separated with commas or a JSON list in\nvalues.yml definition from config server, or you can use yaml format in this file.", items=String.class)
    private List<String> skipPathPrefixes;
    @MapField(configFieldName="passThroughClaims", externalizedKeyName="passThroughClaims", externalized=true, description="When light-gateway or http-sidecar is used for security, sometimes, we need to pass some\nclaims from the JWT or SWT to the backend API for further verification or audit. You can\nselect some claims to pass to the backend API with HTTP headers. The format is a map of\nclaim in the token and a header name that the downstream API is expecting. You can use\nboth JSON or YAML format.\nWhen SwtVerifyHandler is used, the claim names are in https://github.com/networknt/light-4j/blob/master/client/src/main/java/com/networknt/client/oauth/TokenInfo.java\nWhen JwtVerifyHandler is used, the claim names is the JwtClaims claimName.\nYAML\nsecurity.passThroughClaims:\n  clientId: client_id\n  tokenType: token_type\nJSON\nsecurity.passThroughClaims: {\"clientId\":\"client_id\",\"tokenType\":\"token_type\"}", valueType=String.class)
    private Map<String, String> passThroughClaims;

    private SecurityConfig() {
        this(CONFIG_NAME);
    }

    private SecurityConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setCertificate();
        this.setConfigData();
        this.setSkipPathPrefixes();
        this.setPassThroughClaims();
    }

    public static SecurityConfig load() {
        return new SecurityConfig();
    }

    @Deprecated
    public static SecurityConfig load(String configName) {
        return new SecurityConfig(configName);
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setCertificate();
        this.setConfigData();
        this.setSkipPathPrefixes();
        this.setPassThroughClaims();
    }

    @Deprecated
    public void reload(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setCertificate();
        this.setConfigData();
        this.setSkipPathPrefixes();
        this.setPassThroughClaims();
    }

    public Map<String, Object> getCertificate() {
        return this.jwt.getCertificate();
    }

    public boolean isEnableVerifyJwt() {
        return this.enableVerifyJwt;
    }

    public boolean isEnableVerifySwt() {
        return this.enableVerifySwt;
    }

    public String getSwtClientIdHeader() {
        return this.swtClientIdHeader;
    }

    public String getSwtClientSecretHeader() {
        return this.swtClientSecretHeader;
    }

    public boolean isEnableH2c() {
        return this.enableH2c;
    }

    public boolean isEnableRelaxedKeyValidation() {
        return this.enableRelaxedKeyValidation;
    }

    public boolean isEnableExtractScopeToken() {
        return this.enableExtractScopeToken;
    }

    public boolean isEnableVerifyScope() {
        return this.enableVerifyScope;
    }

    public boolean isSkipVerifyScopeWithoutSpec() {
        return this.skipVerifyScopeWithoutSpec;
    }

    public boolean isIgnoreJwtExpiry() {
        return this.ignoreJwtExpiry;
    }

    public boolean isEnableMockJwt() {
        return this.enableMockJwt;
    }

    public int getClockSkewInSeconds() {
        return this.jwt.getClockSkewInSeconds();
    }

    public String getKeyResolver() {
        return this.jwt.getKeyResolver();
    }

    public boolean isLogJwtToken() {
        return this.logJwtToken;
    }

    public boolean isLogClientUserScope() {
        return this.logClientUserScope;
    }

    public boolean isEnableJwtCache() {
        return this.enableJwtCache;
    }

    public int getJwtCacheFullSize() {
        return this.jwtCacheFullSize;
    }

    public boolean isBootstrapFromKeyService() {
        return this.bootstrapFromKeyService;
    }

    public List<String> getSkipPathPrefixes() {
        return this.skipPathPrefixes;
    }

    public Map<String, String> getPassThroughClaims() {
        return this.passThroughClaims;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public String getProviderId() {
        return this.providerId;
    }

    Config getConfig() {
        return this.config;
    }

    private void setCertificate() {
        if (this.getMappedConfig() != null) {
            Map jwtMap = (Map)this.getMappedConfig().get(JWT);
            ObjectMapper mapper = Config.getInstance().getMapper();
            this.jwt = mapper.convertValue((Object)jwtMap, new TypeReference<SecurityJwtConfig>(){});
        }
    }

    private void setConfigData() {
        if (this.getMappedConfig() != null) {
            Object object = this.getMappedConfig().get(ENABLE_VERIFY_JWT);
            if (object != null) {
                this.enableVerifyJwt = Config.loadBooleanValue(ENABLE_VERIFY_JWT, object);
            }
            if ((object = this.getMappedConfig().get(ENABLE_VERIFY_SWT)) != null) {
                this.enableVerifySwt = Config.loadBooleanValue(ENABLE_VERIFY_SWT, object);
            }
            if ((object = this.getMappedConfig().get(SWT_CLIENT_ID_HEADER)) != null) {
                this.swtClientIdHeader = (String)object;
            }
            if ((object = this.getMappedConfig().get(SWT_CLIENT_SECRET_HEADER)) != null) {
                this.swtClientSecretHeader = (String)object;
            }
            if ((object = this.getMappedConfig().get(ENABLE_H2C)) != null) {
                this.enableH2c = Config.loadBooleanValue(ENABLE_H2C, object);
            }
            if ((object = this.getMappedConfig().get(ENABLE_RELAXED_KEY_CONSTRAINTS)) != null) {
                this.enableRelaxedKeyValidation = Config.loadBooleanValue(ENABLE_RELAXED_KEY_CONSTRAINTS, object);
            }
            if ((object = this.getMappedConfig().get(ENABLE_EXTRACT_SCOPE_TOKEN)) != null) {
                this.enableExtractScopeToken = Config.loadBooleanValue(ENABLE_EXTRACT_SCOPE_TOKEN, object);
            }
            if ((object = this.getMappedConfig().get(ENABLE_VERIFY_SCOPE)) != null) {
                this.enableVerifyScope = Config.loadBooleanValue(ENABLE_VERIFY_SCOPE, object);
            }
            if ((object = this.getMappedConfig().get(SKIP_VERIFY_SCOPE_WITHOUT_SPEC)) != null) {
                this.skipVerifyScopeWithoutSpec = Config.loadBooleanValue(SKIP_VERIFY_SCOPE_WITHOUT_SPEC, object);
            }
            if ((object = this.getMappedConfig().get(ENABLE_MOCK_JWT)) != null) {
                this.enableMockJwt = Config.loadBooleanValue(ENABLE_MOCK_JWT, object);
            }
            if ((object = this.getMappedConfig().get(LOG_JWT_TOKEN)) != null) {
                this.logJwtToken = Config.loadBooleanValue(LOG_JWT_TOKEN, object);
            }
            if ((object = this.getMappedConfig().get(LOG_CLIENT_USER_SCOPE)) != null) {
                this.logClientUserScope = Config.loadBooleanValue(LOG_CLIENT_USER_SCOPE, object);
            }
            if ((object = this.getMappedConfig().get(ENABLE_JWT_CACHE)) != null) {
                this.enableJwtCache = Config.loadBooleanValue(ENABLE_JWT_CACHE, object);
            }
            if ((object = this.getMappedConfig().get(JWT_CACHE_FULL_SIZE)) != null) {
                this.jwtCacheFullSize = Config.loadIntegerValue(JWT_CACHE_FULL_SIZE, object);
            }
            if ((object = this.getMappedConfig().get(BOOTSTRAP_FROM_KEY_SERVICE)) != null) {
                this.bootstrapFromKeyService = Config.loadBooleanValue(BOOTSTRAP_FROM_KEY_SERVICE, object);
            }
            if ((object = this.getMappedConfig().get(IGNORE_JWT_EXPIRY)) != null) {
                this.ignoreJwtExpiry = Config.loadBooleanValue(IGNORE_JWT_EXPIRY, object);
            }
            if ((object = this.getMappedConfig().get(PROVIDER_ID)) != null) {
                this.providerId = (String)object;
            }
        }
    }

    private void setSkipPathPrefixes() {
        if (this.mappedConfig != null && this.mappedConfig.get(SKIP_PATH_PREFIXES) != null) {
            Object object = this.mappedConfig.get(SKIP_PATH_PREFIXES);
            this.skipPathPrefixes = new ArrayList<String>();
            if (object instanceof String) {
                String s2 = (String)object;
                s2 = s2.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("s = " + s2);
                }
                if (s2.startsWith("[")) {
                    try {
                        this.skipPathPrefixes = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                    }
                    catch (Exception e) {
                        throw new ConfigException("could not parse the skipPathPrefixes json with a list of strings.");
                    }
                } else {
                    this.skipPathPrefixes = Arrays.asList(s2.split("\\s*,\\s*"));
                }
            } else if (object instanceof List) {
                List prefixes = (List)object;
                prefixes.forEach(item -> this.skipPathPrefixes.add((String)item));
            } else {
                throw new ConfigException("skipPathPrefixes must be a string or a list of strings.");
            }
        }
    }

    private void setPassThroughClaims() {
        if (this.mappedConfig != null && this.mappedConfig.get(PASS_THROUGH_CLAIMS) != null) {
            Object obj = this.mappedConfig.get(PASS_THROUGH_CLAIMS);
            if (obj instanceof String) {
                String s2 = (String)obj;
                if (logger.isTraceEnabled()) {
                    logger.trace("s = " + s2);
                }
                if (s2.startsWith("{")) {
                    try {
                        this.passThroughClaims = Config.getInstance().getMapper().readValue(s2, Map.class);
                    }
                    catch (IOException e) {
                        logger.error("IOException:", e);
                    }
                } else {
                    this.passThroughClaims = new HashMap<String, String>();
                    for (String keyValue : s2.split(" *& *")) {
                        String[] pairs = keyValue.split(" *= *", 2);
                        this.passThroughClaims.put(pairs[0], pairs[1]);
                    }
                }
            } else if (obj instanceof Map) {
                this.passThroughClaims = (Map)obj;
            } else {
                logger.error("passThroughClaims is the wrong type. Only JSON map or YAML map is supported.");
            }
        }
    }
}

