/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.security;

import com.networknt.client.oauth.TokenInfo;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.monad.Result;
import com.networknt.security.SecurityConfig;
import com.networknt.security.SwtVerifier;
import com.networknt.security.UndertowVerifyHandler;
import com.networknt.status.Status;
import com.networknt.utility.StringUtils;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSwtVerifyHandler
extends UndertowVerifyHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(AbstractSwtVerifyHandler.class);
    static final String STATUS_INVALID_AUTH_TOKEN = "ERR10000";
    static final String STATUS_AUTH_TOKEN_EXPIRED = "ERR10001";
    static final String STATUS_MISSING_AUTH_TOKEN = "ERR10002";
    static final String STATUS_INVALID_SCOPE_TOKEN = "ERR10003";
    static final String STATUS_SCOPE_TOKEN_EXPIRED = "ERR10004";
    static final String STATUS_AUTH_TOKEN_SCOPE_MISMATCH = "ERR10005";
    static final String STATUS_SCOPE_TOKEN_SCOPE_MISMATCH = "ERR10006";
    static final String STATUS_INVALID_REQUEST_PATH = "ERR10007";
    static final String STATUS_METHOD_NOT_ALLOWED = "ERR10008";
    static final String STATUS_CLIENT_EXCEPTION = "ERR10082";
    public static SwtVerifier swtVerifier;
    public static SecurityConfig config;
    public volatile HttpHandler next;

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnableVerifySwt();
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Status status;
        if (logger.isDebugEnabled()) {
            logger.debug("SwtVerifyHandler.handleRequest starts.");
        }
        String reqPath = exchange.getRequestPath();
        if (config.getSkipPathPrefixes() != null) {
            if (config.getSkipPathPrefixes().stream().anyMatch(reqPath::startsWith)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Skip request path base on skipPathPrefixes for " + reqPath);
                }
                Handler.next(exchange, this.next);
                if (logger.isDebugEnabled()) {
                    logger.debug("SwtVerifyHandler.handleRequest ends.");
                }
                return;
            }
        }
        if ((status = this.handleSwt(exchange, reqPath, null)) != null) {
            this.setExchangeStatus(exchange, status);
            exchange.endExchange();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("SwtVerifyHandler.handleRequest ends.");
            }
            Handler.next(exchange, this.next);
        }
    }

    public Status handleSwt(HttpServerExchange exchange, String reqPath, List<String> jwkServiceIds) throws Exception {
        HashMap<String, Object> auditInfo = null;
        HeaderMap headerMap = exchange.getRequestHeaders();
        String authorization = headerMap.getFirst(Headers.AUTHORIZATION);
        if (logger.isTraceEnabled() && authorization != null && authorization.length() > 10) {
            logger.trace("Authorization header = " + authorization.substring(0, 10));
        }
        if (authorization == null) {
            Status status = new Status(STATUS_MISSING_AUTH_TOKEN, new Object[0]);
            if (logger.isTraceEnabled()) {
                logger.trace("SwtVerifyHandler.handleRequest ends with an error {}", (Object)status);
            }
            return status;
        }
        if (authorization.trim().length() < 6) {
            Status status = new Status(STATUS_INVALID_AUTH_TOKEN, new Object[0]);
            if (logger.isTraceEnabled()) {
                logger.trace("SwtVerifyHandler.handleRequest ends with an error {}", (Object)status);
            }
            return status;
        }
        String swt = SwtVerifier.getTokenFromAuthorization(authorization = this.getScopeToken(authorization, headerMap));
        if (swt != null) {
            Result<TokenInfo> tokenInfoResult;
            if (logger.isTraceEnabled()) {
                logger.trace("parsed swt from authorization = " + swt.substring(0, 10));
            }
            String swtClientId = headerMap.getFirst(config.getSwtClientIdHeader());
            String swtClientSecret = headerMap.getFirst(config.getSwtClientSecretHeader());
            if (logger.isTraceEnabled()) {
                logger.trace("header swtClientId = " + swtClientId + ", header swtClientSecret = " + StringUtils.maskHalfString(swtClientSecret));
            }
            if ((tokenInfoResult = swtVerifier.verifySwt(swt, reqPath, jwkServiceIds, swtClientId, swtClientSecret)).isFailure()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("SwtVerifyHandler.handleRequest ends with an error {}", (Object)tokenInfoResult.getError());
                }
                return tokenInfoResult.getError();
            }
            TokenInfo tokenInfo = tokenInfoResult.getResult();
            auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
            if (auditInfo == null) {
                auditInfo = new HashMap<String, Object>();
                exchange.putAttachment(AttachmentConstants.AUDIT_INFO, auditInfo);
            }
            String clientId = tokenInfo.getClientId();
            auditInfo.put("client_id", clientId);
            String issuer = tokenInfo.getIss();
            auditInfo.put("issuer_claims", issuer);
            if (!config.isEnableH2c() && this.checkForH2CRequest(headerMap)) {
                Status status = new Status(STATUS_METHOD_NOT_ALLOWED, new Object[0]);
                if (logger.isTraceEnabled()) {
                    logger.trace("SwtVerifyHandler.handleRequest ends with an error {}", (Object)status);
                }
                return status;
            }
            String callerId = headerMap.getFirst(HttpStringConstants.CALLER_ID);
            if (callerId != null) {
                auditInfo.put("caller_id", callerId);
            }
            if (config != null && config.isEnableVerifyScope()) {
                ArrayList<String> secondaryScopes;
                String scopeHeader;
                String scopeSwt;
                Status status;
                if (logger.isTraceEnabled()) {
                    logger.trace("verify scope from the primary token when enableVerifyScope is true");
                }
                if ((status = this.hasValidSecondaryScopes(exchange, scopeSwt = SwtVerifier.getTokenFromAuthorization(scopeHeader = headerMap.getFirst(HttpStringConstants.SCOPE_TOKEN)), secondaryScopes = new ArrayList<String>(), reqPath, jwkServiceIds, auditInfo)) != null) {
                    return status;
                }
                status = this.hasValidScope(exchange, scopeHeader, secondaryScopes, tokenInfo, this.getSpecScopes(exchange, auditInfo));
                if (status != null) {
                    return status;
                }
            }
            if (config.getPassThroughClaims() != null && config.getPassThroughClaims().size() > 0) {
                for (Map.Entry<String, String> entry : config.getPassThroughClaims().entrySet()) {
                    String key = entry.getKey();
                    String header = entry.getValue();
                    Field field = tokenInfo.getClass().getDeclaredField(key);
                    field.setAccessible(true);
                    Object value = field.get(tokenInfo);
                    if (logger.isTraceEnabled()) {
                        logger.trace("pass through header {} with value {}", (Object)header, value);
                    }
                    headerMap.put(new HttpString(header), value.toString());
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace("complete SWT verification for request path = " + exchange.getRequestURI());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("SwtVerifyHandler.handleRequest ends.");
            }
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SwtVerifyHandler.handleRequest ends with an error.");
        }
        return new Status(STATUS_MISSING_AUTH_TOKEN, new Object[0]);
    }

    protected Status hasValidScope(HttpServerExchange exchange, String scopeHeader, List<String> secondaryScopes, TokenInfo tokenInfo, List<String> specScopes) {
        if (config.isEnableVerifyScope()) {
            if (scopeHeader != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("validate the scope with scope token");
                }
                if (secondaryScopes == null || !this.matchedScopes(secondaryScopes, specScopes)) {
                    return new Status(STATUS_SCOPE_TOKEN_SCOPE_MISMATCH, secondaryScopes, specScopes);
                }
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("validate the scope with primary token");
                }
                List<String> primaryScopes = null;
                String scope = tokenInfo.getScope();
                if (scope != null) {
                    primaryScopes = Arrays.asList(scope.split(" "));
                }
                if (!this.matchedScopes(primaryScopes, specScopes)) {
                    return new Status(STATUS_AUTH_TOKEN_SCOPE_MISMATCH, primaryScopes, specScopes);
                }
            }
        }
        return null;
    }

    protected boolean matchedScopes(List<String> tokenScopes, Collection<String> specScopes) {
        boolean matched = false;
        if (specScopes != null && specScopes.size() > 0) {
            if (tokenScopes != null && tokenScopes.size() > 0) {
                for (String scope : specScopes) {
                    if (!tokenScopes.contains(scope)) continue;
                    matched = true;
                    break;
                }
            }
        } else {
            matched = true;
        }
        return matched;
    }

    protected Status hasValidSecondaryScopes(HttpServerExchange exchange, String scopeSwt, List<String> secondaryScopes, String reqPath, List<String> jwkServiceIds, Map<String, Object> auditInfo) {
        if (scopeSwt != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("start verifying scope token = " + scopeSwt.substring(0, 10));
            }
            try {
                Result<TokenInfo> scopeTokenInfo;
                HeaderMap headerMap = exchange.getRequestHeaders();
                String swtClientId = headerMap.getFirst(config.getSwtClientIdHeader());
                String swtClientSecret = headerMap.getFirst(config.getSwtClientSecretHeader());
                if (logger.isTraceEnabled()) {
                    logger.trace("header swtClientId = " + swtClientId + ", header swtClientSecret = " + StringUtils.maskHalfString(swtClientSecret));
                }
                if ((scopeTokenInfo = swtVerifier.verifySwt(scopeSwt, reqPath, jwkServiceIds, swtClientId, swtClientSecret)).isFailure()) {
                    return scopeTokenInfo.getError();
                }
                TokenInfo tokenInfo = scopeTokenInfo.getResult();
                String scope = tokenInfo.getScope();
                if (scope != null) {
                    secondaryScopes.addAll(Arrays.asList(scope.split(" ")));
                    auditInfo.put("scope_client_id", tokenInfo.getClientId());
                }
            }
            catch (Exception e) {
                logger.error("Exception", e);
                return new Status(STATUS_CLIENT_EXCEPTION, e.getMessage());
            }
        }
        return null;
    }

    public abstract List<String> getSpecScopes(HttpServerExchange var1, Map<String, Object> var2) throws Exception;

    protected String getScopeToken(String authorization, HeaderMap headerMap) {
        String returnToken = authorization;
        if (returnToken != null && !returnToken.substring(0, 6).equalsIgnoreCase("Bearer")) {
            returnToken = headerMap.getFirst(HttpStringConstants.SCOPE_TOKEN);
            if (logger.isTraceEnabled() && returnToken != null && returnToken.length() > 10) {
                logger.trace("The replaced authorization from X-Scope-Token header = " + returnToken.substring(0, 10));
            }
        }
        return returnToken;
    }
}

