/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.security;

import com.networknt.exception.ExpiredTokenException;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.security.IJwtVerifyHandler;
import com.networknt.security.JwtVerifier;
import com.networknt.security.SecurityConfig;
import com.networknt.security.UndertowVerifyHandler;
import com.networknt.security.VerificationException;
import com.networknt.status.Status;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJwtVerifyHandler
extends UndertowVerifyHandler
implements MiddlewareHandler,
IJwtVerifyHandler {
    static final Logger logger = LoggerFactory.getLogger(AbstractJwtVerifyHandler.class);
    static final String STATUS_INVALID_AUTH_TOKEN = "ERR10000";
    static final String STATUS_AUTH_TOKEN_EXPIRED = "ERR10001";
    static final String TOKEN_VERIFICATION_EXCEPTION = "ERR10090";
    static final String STATUS_MISSING_AUTH_TOKEN = "ERR10002";
    static final String STATUS_INVALID_SCOPE_TOKEN = "ERR10003";
    static final String STATUS_SCOPE_TOKEN_EXPIRED = "ERR10004";
    static final String STATUS_AUTH_TOKEN_SCOPE_MISMATCH = "ERR10005";
    static final String STATUS_SCOPE_TOKEN_SCOPE_MISMATCH = "ERR10006";
    static final String STATUS_INVALID_REQUEST_PATH = "ERR10007";
    static final String STATUS_METHOD_NOT_ALLOWED = "ERR10008";
    public static SecurityConfig config;
    public static JwtVerifier jwtVerifier;
    public volatile HttpHandler next;

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("JwtVerifyHandler.handleRequest starts.");
        }
        if (this.isSkipAuth(exchange)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Skipped! JwtVerifyHandler.handleRequest ends.");
            }
            Handler.next(exchange, this.next);
            return;
        }
        String reqPath = exchange.getRequestPath();
        Status status = this.handleJwt(exchange, null, reqPath, null);
        if (status != null) {
            this.setExchangeStatus(exchange, status);
            exchange.endExchange();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("JwtVerifyHandler.handleRequest ends.");
            }
            Handler.next(exchange, this.next);
        }
    }

    public Status handleJwt(HttpServerExchange exchange, String pathPrefix, String reqPath, List<String> jwkServiceIds) throws Exception {
        HashMap<String, Object> auditInfo = null;
        HeaderMap headerMap = exchange.getRequestHeaders();
        String authorization = headerMap.getFirst(Headers.AUTHORIZATION);
        if (logger.isTraceEnabled() && authorization != null && authorization.length() > 10) {
            logger.trace("Authorization header = " + authorization.substring(0, 10));
        }
        if (authorization == null) {
            Status status = new Status(STATUS_MISSING_AUTH_TOKEN, new Object[0]);
            if (logger.isTraceEnabled()) {
                logger.trace("JwtVerifyHandler.handleRequest ends with an error {}", (Object)status);
            }
            return status;
        }
        if (authorization.trim().length() < 6) {
            Status status = new Status(STATUS_INVALID_AUTH_TOKEN, new Object[0]);
            if (logger.isTraceEnabled()) {
                logger.trace("JwtVerifyHandler.handleRequest ends with an error {}", (Object)status);
            }
            return status;
        }
        authorization = this.getScopeToken(authorization, headerMap);
        boolean ignoreExpiry = config.isIgnoreJwtExpiry();
        String jwt = JwtVerifier.getTokenFromAuthorization(authorization);
        if (jwt != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("parsed jwt from authorization = " + jwt.substring(0, 10));
            }
            try {
                JwtClaims claims = jwtVerifier.verifyJwt(jwt, ignoreExpiry, true, pathPrefix, reqPath, jwkServiceIds);
                if (logger.isTraceEnabled()) {
                    logger.trace("claims = " + claims.toJson());
                }
                if ((auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO)) == null) {
                    auditInfo = new HashMap<String, Object>();
                    exchange.putAttachment(AttachmentConstants.AUDIT_INFO, auditInfo);
                }
                String clientId = claims.getStringClaimValue("client_id");
                String userId = claims.getStringClaimValue("user_id");
                String email = claims.getStringClaimValue("eml");
                String host = claims.getStringClaimValue("host");
                String issuer = claims.getStringClaimValue("iss");
                if (clientId == null) {
                    clientId = claims.getStringClaimValue("cid");
                }
                if (userId == null) {
                    userId = claims.getStringClaimValue("uid");
                }
                auditInfo.put("user_id", userId);
                auditInfo.put("subject_claims", claims);
                auditInfo.put("client_id", clientId);
                auditInfo.put("issuer_claims", issuer);
                if (email != null) {
                    auditInfo.put("email", email);
                }
                if (host != null) {
                    auditInfo.put("host", host);
                }
                if (!config.isEnableH2c() && this.checkForH2CRequest(headerMap)) {
                    Status status = new Status(STATUS_METHOD_NOT_ALLOWED, new Object[0]);
                    if (logger.isTraceEnabled()) {
                        logger.trace("JwtVerifyHandler.handleRequest ends with an error {}", (Object)status);
                    }
                    return status;
                }
                String callerId = headerMap.getFirst(HttpStringConstants.CALLER_ID);
                if (callerId != null) {
                    auditInfo.put("caller_id", callerId);
                }
                if (config != null && config.isEnableVerifyScope()) {
                    ArrayList<String> secondaryScopes;
                    String scopeHeader;
                    String scopeJwt;
                    Status status;
                    if (logger.isTraceEnabled()) {
                        logger.trace("verify scope from the primary token when enableVerifyScope is true");
                    }
                    if ((status = this.hasValidSecondaryScopes(exchange, scopeJwt = JwtVerifier.getTokenFromAuthorization(scopeHeader = headerMap.getFirst(HttpStringConstants.SCOPE_TOKEN)), secondaryScopes = new ArrayList<String>(), ignoreExpiry, pathPrefix, reqPath, jwkServiceIds, auditInfo)) != null) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("JwtVerifyHandler.handleRequest ends with an error {}", (Object)status);
                        }
                        return status;
                    }
                    status = this.hasValidScope(exchange, scopeHeader, secondaryScopes, claims, this.getSpecScopes(exchange, auditInfo));
                    if (status != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("JwtVerifyHandler.handleRequest ends with an error {}", (Object)status);
                        }
                        return status;
                    }
                }
                if (config.getPassThroughClaims() != null && config.getPassThroughClaims().size() > 0) {
                    for (Map.Entry<String, String> entry : config.getPassThroughClaims().entrySet()) {
                        String key = entry.getKey();
                        String header = entry.getValue();
                        Object value = claims.getClaimValue(key);
                        if (logger.isTraceEnabled()) {
                            logger.trace("pass through header {} with value {}", (Object)header, value);
                        }
                        headerMap.put(new HttpString(header), value.toString());
                    }
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("complete JWT verification for request path = " + exchange.getRequestURI());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("JwtVerifyHandler.handleRequest ends.");
                }
                return null;
            }
            catch (InvalidJwtException e) {
                logger.error("InvalidJwtException: ", e);
                Status status = new Status(STATUS_INVALID_AUTH_TOKEN, new Object[0]);
                if (logger.isTraceEnabled()) {
                    logger.trace("JwtVerifyHandler.handleRequest ends with an error {}", (Object)status);
                }
                return status;
            }
            catch (ExpiredTokenException e) {
                logger.error("ExpiredTokenException", e);
                Status status = new Status(STATUS_AUTH_TOKEN_EXPIRED, new Object[0]);
                if (logger.isTraceEnabled()) {
                    logger.trace("JwtVerifyHandler.handleRequest ends with an error {}", (Object)status);
                }
                return status;
            }
            catch (VerificationException e) {
                logger.error("VerificationException", e);
                Status status = new Status(TOKEN_VERIFICATION_EXCEPTION, e.getMessage());
                if (logger.isTraceEnabled()) {
                    logger.trace("JwtVerifyHandler.handleRequest ends with an error {}", (Object)status);
                }
                return status;
            }
        }
        Status status = new Status(STATUS_MISSING_AUTH_TOKEN, new Object[0]);
        if (logger.isTraceEnabled()) {
            logger.trace("JwtVerifyHandler.handleRequest ends with an error {}", (Object)status);
        }
        return status;
    }

    protected String getScopeToken(String authorization, HeaderMap headerMap) {
        String returnToken = authorization;
        if (returnToken != null && !returnToken.substring(0, 6).equalsIgnoreCase("Bearer")) {
            returnToken = headerMap.getFirst(HttpStringConstants.SCOPE_TOKEN);
            if (logger.isTraceEnabled() && returnToken != null && returnToken.length() > 10) {
                logger.trace("The replaced authorization from X-Scope-Token header = " + returnToken.substring(0, 10));
            }
        }
        return returnToken;
    }

    public abstract boolean isSkipAuth(HttpServerExchange var1);

    public abstract List<String> getSpecScopes(HttpServerExchange var1, Map<String, Object> var2) throws Exception;

    protected Status hasValidSecondaryScopes(HttpServerExchange exchange, String scopeJwt, List<String> secondaryScopes, boolean ignoreExpiry, String pathPrefix, String reqPath, List<String> jwkServiceIds, Map<String, Object> auditInfo) {
        if (scopeJwt != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("start verifying scope token = " + scopeJwt.substring(0, 10));
            }
            try {
                JwtClaims scopeClaims = jwtVerifier.verifyJwt(scopeJwt, ignoreExpiry, true, pathPrefix, reqPath, jwkServiceIds);
                Object scopeClaim = scopeClaims.getClaimValue("scope");
                if (scopeClaim instanceof String) {
                    secondaryScopes.addAll(Arrays.asList(scopeClaims.getStringClaimValue("scope").split(" ")));
                } else if (scopeClaim instanceof List) {
                    secondaryScopes.addAll(scopeClaims.getStringListClaimValue("scope"));
                }
                if (secondaryScopes.isEmpty()) {
                    Object scpClaim = scopeClaims.getClaimValue("scp");
                    if (scpClaim instanceof String) {
                        secondaryScopes.addAll(Arrays.asList(scopeClaims.getStringClaimValue("scp").split(" ")));
                    } else if (scpClaim instanceof List) {
                        secondaryScopes.addAll(scopeClaims.getStringListClaimValue("scp"));
                    }
                }
                auditInfo.put("scope_client_id", scopeClaims.getStringClaimValue("client_id"));
                auditInfo.put("access_claims", scopeClaims);
            }
            catch (InvalidJwtException e) {
                logger.error("InvalidJwtException", e);
                return new Status(STATUS_INVALID_SCOPE_TOKEN, new Object[0]);
            }
            catch (MalformedClaimException e) {
                logger.error("MalformedClaimException", e);
                return new Status(STATUS_INVALID_AUTH_TOKEN, new Object[0]);
            }
            catch (ExpiredTokenException e) {
                logger.error("ExpiredTokenException", e);
                return new Status(STATUS_SCOPE_TOKEN_EXPIRED, new Object[0]);
            }
        }
        return null;
    }

    protected Status hasValidScope(HttpServerExchange exchange, String scopeHeader, List<String> secondaryScopes, JwtClaims claims, List<String> specScopes) {
        if (config.isEnableVerifyScope()) {
            if (logger.isTraceEnabled()) {
                logger.trace("validate the scope with the spec scopes {}", (Object)specScopes);
            }
            if (scopeHeader != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("validate the scope with scope token");
                }
                if (secondaryScopes == null || !this.matchedScopes(secondaryScopes, specScopes)) {
                    return new Status(STATUS_SCOPE_TOKEN_SCOPE_MISMATCH, secondaryScopes, specScopes);
                }
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("validate the scope with primary token");
                }
                List<String> primaryScopes = null;
                try {
                    Object scopeClaim = claims.getClaimValue("scope");
                    if (scopeClaim instanceof String) {
                        primaryScopes = Arrays.asList(claims.getStringClaimValue("scope").split(" "));
                    } else if (scopeClaim instanceof List) {
                        primaryScopes = claims.getStringListClaimValue("scope");
                    }
                    if (primaryScopes == null || primaryScopes.isEmpty()) {
                        Object scpClaim = claims.getClaimValue("scp");
                        if (scpClaim instanceof String) {
                            primaryScopes = Arrays.asList(claims.getStringClaimValue("scp").split(" "));
                        } else if (scpClaim instanceof List) {
                            primaryScopes = claims.getStringListClaimValue("scp");
                        }
                    }
                }
                catch (MalformedClaimException e) {
                    logger.error("MalformedClaimException", e);
                    return new Status(STATUS_INVALID_AUTH_TOKEN, new Object[0]);
                }
                if (!this.matchedScopes(primaryScopes, specScopes)) {
                    return new Status(STATUS_AUTH_TOKEN_SCOPE_MISMATCH, primaryScopes, specScopes);
                }
            }
        }
        return null;
    }

    protected boolean matchedScopes(List<String> jwtScopes, Collection<String> specScopes) {
        boolean matched = false;
        if (specScopes != null && specScopes.size() > 0) {
            if (jwtScopes != null && jwtScopes.size() > 0) {
                for (String scope : specScopes) {
                    if (!jwtScopes.contains(scope)) continue;
                    matched = true;
                    break;
                }
            }
        } else {
            matched = true;
        }
        return matched;
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public JwtVerifier getJwtVerifier() {
        return jwtVerifier;
    }
}

