/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.output;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.output.OutputUnit;
import com.networknt.schema.output.OutputUnitData;
import com.networknt.schema.output.OutputUnitKey;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class ListOutputUnitFormatter {
    public static OutputUnit format(OutputUnit root, OutputUnitData data) {
        Map<OutputUnitKey, Boolean> valid = data.getValid();
        Map<OutputUnitKey, Map<String, Object>> errors = data.getErrors();
        Map<OutputUnitKey, Map<String, Object>> annotations2 = data.getAnnotations();
        Map<OutputUnitKey, Map<String, Object>> droppedAnnotations = data.getDroppedAnnotations();
        for (Map.Entry<OutputUnitKey, Boolean> entry : valid.entrySet()) {
            List<OutputUnit> details;
            Map<String, Object> map;
            Map<String, Object> annotationsMap;
            OutputUnit output = new OutputUnit();
            OutputUnitKey key = entry.getKey();
            output.setValid(entry.getValue());
            output.setEvaluationPath(key.getEvaluationPath().toString());
            output.setSchemaLocation(key.getSchemaLocation().toString());
            output.setInstanceLocation(key.getInstanceLocation().toString());
            Map<String, Object> errorMap = errors.get(key);
            if (errorMap != null && !errorMap.isEmpty()) {
                if (output.getErrors() == null) {
                    output.setErrors(new LinkedHashMap<String, Object>());
                }
                for (Map.Entry<String, Object> entry2 : errorMap.entrySet()) {
                    output.getErrors().put(entry2.getKey(), entry2.getValue());
                }
            }
            if ((annotationsMap = annotations2.get(key)) != null && !annotationsMap.isEmpty()) {
                if (output.getAnnotations() == null) {
                    output.setAnnotations(new LinkedHashMap<String, Object>());
                }
                for (Object annotationEntry : annotationsMap.entrySet()) {
                    output.getAnnotations().put((String)annotationEntry.getKey(), annotationEntry.getValue());
                }
            }
            if ((map = droppedAnnotations.get(key)) != null && !map.isEmpty()) {
                Object annotationEntry;
                if (output.getDroppedAnnotations() == null) {
                    output.setDroppedAnnotations(new LinkedHashMap<String, Object>());
                }
                annotationEntry = map.entrySet().iterator();
                while (annotationEntry.hasNext()) {
                    Map.Entry entry3 = (Map.Entry)annotationEntry.next();
                    output.getDroppedAnnotations().put((String)entry3.getKey(), entry3.getValue());
                }
            }
            if ((details = root.getDetails()) == null) {
                details = new ArrayList<OutputUnit>();
                root.setDetails(details);
            }
            details.add(output);
        }
        return root;
    }

    public static OutputUnit format(Set<ValidationMessage> validationMessages, ExecutionContext executionContext, ValidationContext validationContext, Function<ValidationMessage, Object> assertionMapper) {
        OutputUnit root = new OutputUnit();
        root.setValid(validationMessages.isEmpty());
        return ListOutputUnitFormatter.format(root, OutputUnitData.from(validationMessages, executionContext, assertionMapper));
    }
}

