/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.Format;
import com.networknt.schema.format.DateFormat;
import com.networknt.schema.format.DateTimeFormat;
import com.networknt.schema.format.DurationFormat;
import com.networknt.schema.format.EmailFormat;
import com.networknt.schema.format.IPv6Format;
import com.networknt.schema.format.IdnEmailFormat;
import com.networknt.schema.format.IdnHostnameFormat;
import com.networknt.schema.format.IriFormat;
import com.networknt.schema.format.IriReferenceFormat;
import com.networknt.schema.format.PatternFormat;
import com.networknt.schema.format.RegexFormat;
import com.networknt.schema.format.TimeFormat;
import com.networknt.schema.format.UriFormat;
import com.networknt.schema.format.UriReferenceFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Formats {
    public static final List<Format> DEFAULT;

    private Formats() {
    }

    static PatternFormat pattern(String name2, String regex, String messageKey) {
        return PatternFormat.of(name2, regex, messageKey);
    }

    static PatternFormat pattern(String name2, String regex) {
        return Formats.pattern(name2, regex, null);
    }

    static {
        ArrayList<Format> formats = new ArrayList<Format>();
        formats.add(Formats.pattern("hostname", "^([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])(\\.([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9]))*$", "format.hostname"));
        formats.add(Formats.pattern("ipv4", "^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$", "format.ipv4"));
        formats.add(new IPv6Format());
        formats.add(Formats.pattern("json-pointer", "^(/([^/#~]|[~](?=[01]))*)*$", "format.json-pointer"));
        formats.add(Formats.pattern("relative-json-pointer", "^(0|([1-9]\\d*))(#|(/([^/#~]|[~](?=[01]))*)*)$", "format.relative-json-pointer"));
        formats.add(Formats.pattern("uri-template", "^([^\\p{Cntrl}\"'%<>\\^`\\{|\\}]|%\\p{XDigit}{2}|\\{[+#./;?&=,!@|]?((\\w|%\\p{XDigit}{2})(\\.?(\\w|%\\p{XDigit}{2}))*(:[1-9]\\d{0,3}|\\*)?)(,((\\w|%\\p{XDigit}{2})(\\.?(\\w|%\\p{XDigit}{2}))*(:[1-9]\\d{0,3}|\\*)?))*\\})*$", "format.uri-template"));
        formats.add(Formats.pattern("uuid", "^\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}$", "format.uuid"));
        formats.add(new DateFormat());
        formats.add(new DateTimeFormat());
        formats.add(new EmailFormat());
        formats.add(new IdnEmailFormat());
        formats.add(new IdnHostnameFormat());
        formats.add(new IriFormat());
        formats.add(new IriReferenceFormat());
        formats.add(new RegexFormat());
        formats.add(new TimeFormat());
        formats.add(new UriFormat());
        formats.add(new UriReferenceFormat());
        formats.add(new DurationFormat());
        formats.add(Formats.pattern("alpha", "^[a-zA-Z]+$"));
        formats.add(Formats.pattern("alphanumeric", "^[a-zA-Z0-9]+$"));
        formats.add(Formats.pattern("color", "(#?([0-9A-Fa-f]{3,6})\\b)|(aqua)|(black)|(blue)|(fuchsia)|(gray)|(green)|(lime)|(maroon)|(navy)|(olive)|(orange)|(purple)|(red)|(silver)|(teal)|(white)|(yellow)|(rgb\\(\\s*\\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\b\\s*,\\s*\\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\b\\s*,\\s*\\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\b\\s*\\))|(rgb\\(\\s*(\\d?\\d%|100%)+\\s*,\\s*(\\d?\\d%|100%)+\\s*,\\s*(\\d?\\d%|100%)+\\s*\\))"));
        formats.add(Formats.pattern("ip-address", "^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$"));
        formats.add(Formats.pattern("phone", "^\\+(?:[0-9] ?){6,14}[0-9]$"));
        formats.add(Formats.pattern("style", "\\s*(.+?):\\s*([^;]+);?"));
        formats.add(Formats.pattern("utc-millisec", "^[0-9]+(\\.?[0-9]+)?$"));
        DEFAULT = Collections.unmodifiableList(formats);
    }
}

