/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.rpc.router;

import com.networknt.config.Config;
import com.networknt.resource.PathResourceProvider;
import com.networknt.resource.PredicatedHandlersProvider;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.RpcRouterConfig;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.server.Server;
import com.networknt.server.StartupHookProvider;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.ModuleRegistry;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcStartupHookProvider
implements StartupHookProvider {
    static final Logger logger = LoggerFactory.getLogger(RpcStartupHookProvider.class);
    static RpcRouterConfig config;
    public static final Map<String, HybridHandler> serviceMap;
    public static PathResourceProvider[] pathResourceProviders;
    public static PredicatedHandlersProvider[] predicatedHandlersProviders;

    public RpcStartupHookProvider() {
        logger.info("RpcStartupHookProvider is constructed");
        config = RpcRouterConfig.load();
        ModuleRegistry.registerModule("rpc-router", RpcStartupHookProvider.class.getName(), Config.getNoneDecryptedInstance().getJsonMapConfigNoCache("rpc-router"), null);
    }

    @Override
    public void onStartup() {
        List<String> handlers;
        logger.debug("Handler scanning package = {}", (Object)config.getHandlerPackages());
        Object[] packages = config.getHandlerPackages().toArray(new String[0]);
        System.out.println("packages: " + Arrays.toString(packages));
        try (ScanResult scanResult = new ClassGraph().acceptPackages((String[])packages).enableAllInfo().scan();){
            handlers = scanResult.getClassesWithAnnotation(ServiceHandler.class.getName()).getNames();
        }
        logger.debug("RpcStartupHookProvider.onStartup handlers size = {}", (Object)handlers.size());
        for (String className : handlers) {
            try {
                Class<?> handler = Class.forName(className);
                ServiceHandler a = handler.getAnnotation(ServiceHandler.class);
                serviceMap.put(a.id(), (HybridHandler)handler.getConstructor(new Class[0]).newInstance(new Object[0]));
                logger.debug("RpcStartupHookProvider add id {} maps to {}", (Object)a.id(), (Object)className);
                if (!config.isRegisterService()) continue;
                Server.serviceIds.add(a.id().replace('/', '.'));
            }
            catch (Exception e) {
                logger.error("Exception:", e);
            }
        }
        pathResourceProviders = SingletonServiceFactory.getBeans(PathResourceProvider.class);
        predicatedHandlersProviders = SingletonServiceFactory.getBeans(PredicatedHandlersProvider.class);
    }

    static {
        serviceMap = new HashMap<String, HybridHandler>();
    }
}

