/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.rpc.router;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.networknt.config.Config;
import com.networknt.config.schema.ArrayField;
import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.ConfigSchema;
import com.networknt.config.schema.OutputFormat;
import com.networknt.config.schema.StringField;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@ConfigSchema(configKey="rpc-router", configName="rpc-router", configDescription="rpc-router configuration", outputFormats={OutputFormat.JSON_SCHEMA, OutputFormat.YAML})
public class RpcRouterConfig {
    public static final String CONFIG_NAME = "rpc-router";
    public static final String HANDLER_PACKAGE = "handlerPackages";
    public static final String JSON_PATH = "jsonPath";
    public static final String FORM_PATH = "formPath";
    public static final String REGISTER_SERVICE = "registerService";
    @ArrayField(configFieldName="handlerPackages", externalizedKeyName="handlerPackages", externalized=true, description="The hybrid handler package names that is used for scanner during server startup. The more specific of package names, the faster to start\nList the package prefixes for all handlers used. Leave an empty array to indicate wildcard (all packages)", items=String.class)
    @JsonDeserialize(using=HandlerPackageDeserializer.class)
    private List<String> handlerPackages;
    @StringField(configFieldName="jsonPath", externalizedKeyName="jsonPath", externalized=true, description="The JSON RPC API path")
    private String jsonPath;
    @StringField(configFieldName="formPath", externalizedKeyName="formPath", externalized=true, description="The form RPC API path")
    private String formPath;
    @BooleanField(configFieldName="registerService", externalizedKeyName="registerService", externalized=true, description="if we want to register all handlers as services to the Consul for client to discover")
    private boolean registerService;
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();

    private RpcRouterConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    private RpcRouterConfig() {
        this(CONFIG_NAME);
    }

    public static RpcRouterConfig load(String configName) {
        return new RpcRouterConfig(configName);
    }

    public static RpcRouterConfig load() {
        return new RpcRouterConfig();
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
    }

    public void reload(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    public List<String> getHandlerPackages() {
        return this.handlerPackages;
    }

    public String getJsonPath() {
        return this.jsonPath;
    }

    public String getFormPath() {
        return this.formPath;
    }

    public boolean isRegisterService() {
        return this.registerService;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    private void setConfigData() {
        if (this.getMappedConfig() != null) {
            Object object = this.getMappedConfig().get(HANDLER_PACKAGE);
            if (object != null) {
                HandlerPackageDeserializer tempDeserializer = new HandlerPackageDeserializer();
                SimpleModule tempModule = new SimpleModule();
                tempModule.addDeserializer(List.class, tempDeserializer);
                ObjectMapper tempMapper = new ObjectMapper();
                tempMapper.registerModule(tempModule);
                this.handlerPackages = tempMapper.convertValue(object, new TypeReference<List<String>>(){});
            }
            if ((object = this.getMappedConfig().get(JSON_PATH)) != null) {
                this.jsonPath = (String)object;
            }
            if ((object = this.getMappedConfig().get(FORM_PATH)) != null) {
                this.formPath = (String)object;
            }
            if ((object = this.getMappedConfig().get(REGISTER_SERVICE)) != null) {
                this.registerService = Config.loadBooleanValue(REGISTER_SERVICE, object);
            }
        }
    }

    private static class HandlerPackageDeserializer
    extends JsonDeserializer<List<String>> {
        private HandlerPackageDeserializer() {
        }

        @Override
        public List<String> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
            ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
            JsonNode root = (JsonNode)mapper.readTree(jsonParser);
            if (root.isArray()) {
                return mapper.convertValue((Object)root, new TypeReference<List<String>>(){});
            }
            if (root.isTextual()) {
                String packages = mapper.convertValue((Object)root, String.class);
                return Arrays.stream(packages.split(",")).collect(Collectors.toList());
            }
            return List.of();
        }
    }
}

