/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.rpc.router;

import com.networknt.handler.LightHttpHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.RpcStartupHookProvider;
import com.networknt.server.ServerConfig;
import io.undertow.server.DirectByteBufferDeallocator;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonHandler
implements LightHttpHandler {
    static final String STATUS_HANDLER_NOT_FOUND = "ERR11200";
    private static final Logger LOG = LoggerFactory.getLogger(JsonHandler.class);

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String serviceId;
        LOG.trace("JsonHandler is called");
        Map auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        ServerConfig serverConfig = ServerConfig.getInstance();
        if (auditInfo != null) {
            serviceId = (String)auditInfo.get("endpoint");
            if (serviceId == null) {
                this.setExchangeStatus(exchange, STATUS_HANDLER_NOT_FOUND, new Object[0]);
                return;
            }
        } else if (serverConfig != null) {
            serviceId = serverConfig.getServiceId();
        } else {
            this.setExchangeStatus(exchange, STATUS_HANDLER_NOT_FOUND, new Object[0]);
            return;
        }
        LOG.trace("serviceId = {}", (Object)serviceId);
        HybridHandler handler = RpcStartupHookProvider.serviceMap.get(serviceId);
        Map data = (Map)auditInfo.get("hybrid_service_data");
        ByteBuffer result2 = handler.handle(exchange, data);
        if (result2 == null) {
            exchange.setStatusCode(200);
            exchange.endExchange();
        } else {
            exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
                try {
                    DirectByteBufferDeallocator.free(result2);
                }
                finally {
                    nextListener.proceed();
                }
            });
            exchange.getResponseSender().send(result2);
        }
    }
}

