/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.rpc;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.config.Config;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import com.networknt.status.Status;
import com.networknt.utility.NioUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface HybridHandler {
    public static final Logger logger = LoggerFactory.getLogger(HybridHandler.class);
    public static final String REQUEST_SUCCESS = "SUC10200";
    public static final String ERROR_NOT_DEFINED = "ERR10042";
    public static final String STATUS_VALIDATION_ERROR = "ERR11004";

    public ByteBuffer handle(HttpServerExchange var1, Object var2);

    default public ByteBuffer validate(String serviceId, Map<String, Object> schema, Map<String, Object> data) {
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("serviceId = {} data = {}", (Object)serviceId, (Object)Config.getInstance().getMapper().writeValueAsString(data));
            }
            catch (Exception e) {
                logger.error("Exception:", e);
            }
        }
        Object jsonNode = Config.getInstance().getMapper().valueToTree(schema);
        JsonSchemaFactory factory = JsonSchemaFactory.getInstance(SpecVersion.VersionFlag.V202012);
        JsonSchema jsonSchema = factory.getSchema((JsonNode)jsonNode);
        Set<ValidationMessage> errors = jsonSchema.validate((JsonNode)Config.getInstance().getMapper().valueToTree(data));
        ByteBuffer bf = null;
        if (errors.size() > 0) {
            ValidationMessage vm = errors.iterator().next();
            Status status = new Status(STATUS_VALIDATION_ERROR, vm.getMessage());
            logger.error("Validation Error:" + status.toString());
            bf = NioUtils.toByteBuffer(status.toString());
        }
        return bf;
    }

    default public String getStatus(HttpServerExchange exchange, String code, Object ... args2) {
        Status status = new Status(code, args2);
        if (status.getStatusCode() == 0) {
            status = new Status(ERROR_NOT_DEFINED, code);
        }
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        logger.error(status.toString() + " at " + elements[2].getClassName() + "." + elements[2].getMethodName() + "(" + elements[2].getFileName() + ":" + elements[2].getLineNumber() + ")");
        exchange.setStatusCode(status.getStatusCode());
        return status.toString();
    }

    default public String getStatus(HttpServerExchange exchange, Status status) {
        exchange.setStatusCode(status.getStatusCode());
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        logger.error(status.toString() + " at " + elements[2].getClassName() + "." + elements[2].getMethodName() + "(" + elements[2].getFileName() + ":" + elements[2].getLineNumber() + ")");
        return status.toString();
    }
}

