/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.resource;

import com.networknt.config.Config;
import com.networknt.resource.VirtualHost;
import com.networknt.resource.VirtualHostConfig;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.NameVirtualHostHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import java.nio.file.Paths;

public class VirtualHostHandler
implements HttpHandler {
    NameVirtualHostHandler virtualHostHandler;

    public VirtualHostHandler() {
        VirtualHostConfig config = (VirtualHostConfig)Config.getInstance().getJsonObjectConfig("virtual-host", VirtualHostConfig.class);
        this.virtualHostHandler = new NameVirtualHostHandler();
        for (VirtualHost host : config.hosts) {
            this.virtualHostHandler.addHost(host.domain, new PathHandler().addPrefixPath(host.getPath(), new ResourceHandler(new PathResourceManager(Paths.get(host.getBase(), new String[0]), host.getTransferMinSize())).setDirectoryListingEnabled(host.isDirectoryListingEnabled())));
        }
    }

    @Override
    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        this.virtualHostHandler.handleRequest(httpServerExchange);
    }
}

