/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.portal.registry.client;

import com.networknt.client.Http2Client;
import com.networknt.portal.registry.client.WebSocketClientHandlers;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.websockets.client.WebSocketClient;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import java.io.IOException;
import java.net.URI;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Xnio;

public abstract class PortalRegistryWebSocketClient
implements WebSocketClientHandlers {
    private WebSocketChannel channel;
    private FutureNotifier futureNotifier = new FutureNotifier(this);

    public PortalRegistryWebSocketClient(URI uri) throws IOException {
        UndertowXnioSsl ssl = new UndertowXnioSsl(Xnio.getInstance(), OptionMap.EMPTY, Http2Client.createSSLContext());
        WebSocketClient.ConnectionBuilder connectionBuilder = WebSocketClient.connectionBuilder(Http2Client.WORKER, Http2Client.BUFFER_POOL, uri).setSsl(ssl);
        IoFuture<WebSocketChannel> future = connectionBuilder.connect();
        this.channel = future.get();
        future.addNotifier(this.futureNotifier, null);
    }

    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.sendClose();
        }
    }

    public boolean isOpen() {
        return this.channel != null && this.channel.isOpen();
    }

    public void send(String text2) {
        this.send(text2, null);
    }

    public void send(String text2, WebSocketCallback<Void> callback) {
        if (this.channel != null && this.channel.isOpen()) {
            WebSockets.sendText(text2, this.channel, callback);
        }
    }

    private class FutureNotifier
    extends IoFuture.HandlingNotifier<WebSocketChannel, Object> {
        private PortalRegistryWebSocketClient client;

        public FutureNotifier(PortalRegistryWebSocketClient client) {
            this.client = client;
        }

        @Override
        public void handleFailed(IOException exception, Object attachment) {
            this.client.onError(exception);
        }

        @Override
        public void handleDone(WebSocketChannel channel, Object attachment) {
            this.client.channel = channel;
            this.client.onOpen();
            channel.getReceiveSetter().set(new AbstractReceiveListener(){

                @Override
                protected void onFullTextMessage(WebSocketChannel ws, BufferedTextMessage message) throws IOException {
                    FutureNotifier.this.client.onMessage(message.getData());
                }

                @Override
                protected void onError(WebSocketChannel ws, Throwable error) {
                    super.onError(ws, error);
                    FutureNotifier.this.client.onError(new Exception(error));
                }
            });
            channel.resumeReceives();
            channel.addCloseTask(ws -> this.client.onClose(ws.getCloseCode(), ws.getCloseReason()));
        }
    }
}

