/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.metrics;

import com.networknt.config.Config;
import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.ConfigSchema;
import com.networknt.config.schema.IntegerField;
import com.networknt.config.schema.OutputFormat;
import com.networknt.config.schema.StringField;
import java.util.Map;

@ConfigSchema(configName="metrics", configKey="metrics", outputFormats={OutputFormat.JSON_SCHEMA, OutputFormat.YAML})
public class MetricsConfig {
    public static final String CONFIG_NAME = "metrics";
    private static final String ENABLED = "enabled";
    private static final String ENABLED_JVM_MONITOR = "enableJVMMonitor";
    private static final String SERVER_PROTOCOL = "serverProtocol";
    private static final String SERVER_HOST = "serverHost";
    private static final String SERVER_PORT = "serverPort";
    private static final String SERVER_PATH = "serverPath";
    private static final String SERVER_NAME = "serverName";
    private static final String SERVER_USER = "serverUser";
    private static final String SERVER_PASS = "serverPass";
    private static final String REPORT_IN_MINUTES = "reportInMinutes";
    private static final String PRODUCT_NAME = "productName";
    private static final String SEND_SCOPE_CLIENT_ID = "sendScopeClientId";
    private static final String SEND_CALLER_ID = "sendCallerId";
    private static final String SEND_ISSUER = "sendIssuer";
    private static final String ISSUER_REGEX = "issuerRegex";
    @BooleanField(configFieldName="enabled", externalizedKeyName="enabled", externalized=true, defaultValue=true, description="If metrics handler is enabled or not. Default is true as long as one of the handlers is in the\nrequest/response chain.")
    boolean enabled;
    @BooleanField(configFieldName="enableJVMMonitor", externalizedKeyName="enableJVMMonitor", externalized=true, description="If metrics handler is enabled for JVM MBean or not. If enabled, the CPU and Memory usage will be\ncollected and send to the time series database.")
    boolean enableJVMMonitor;
    @StringField(configFieldName="serverProtocol", externalizedKeyName="serverProtocol", externalized=true, defaultValue="http", description="Time series database server protocol. It can be http or https. Others can be added upon request.")
    String serverProtocol;
    @StringField(configFieldName="serverHost", externalizedKeyName="serverHost", externalized=true, defaultValue="localhost", description="Time series database or metrics server hostname.")
    String serverHost;
    @StringField(configFieldName="serverPath", externalizedKeyName="serverPath", externalized=true, defaultValue="/apm/metricFeed", description="Time series database or metrics server request path. It is optional and only some metrics handlers\nwill use it. For example, the Broadcom APM metrics server needs the path to access the agent.")
    String serverPath;
    @IntegerField(configFieldName="serverPort", externalizedKeyName="serverPort", externalized=true, defaultValue=8086, description="Time series database or metrics server port number.")
    int serverPort;
    @StringField(configFieldName="serverName", externalizedKeyName="serverName", externalized=true, defaultValue="metrics", description="Time series database name.")
    String serverName;
    @StringField(configFieldName="serverUser", externalizedKeyName="serverUser", externalized=true, defaultValue="admin", description="Time series database or metrics server user.")
    String serverUser;
    @StringField(configFieldName="serverPass", externalizedKeyName="serverPass", externalized=true, defaultValue="admin", description="Time series database or metrics server password.")
    String serverPass;
    @IntegerField(configFieldName="reportInMinutes", externalizedKeyName="reportInMinutes", externalized=true, defaultValue=1, description="report and reset metrics in minutes.")
    int reportInMinutes;
    @StringField(configFieldName="productName", externalizedKeyName="productName", externalized=true, defaultValue="http-sidecar", description="This is the metrics product name for the centralized time series database. The product name will be\nthe top level category under a Kubernetes cluster or a virtual machine. The following is the light-4j\nproduct list. http-sidecar, kafka-sidecar, corp-gateway, aiz-gateway, proxy-server, proxy-client,\nproxy-lambda, light-balancer etc. By default, http-sidecar is used as a placeholder. Please change it\nbased on your usage in the values.yml file.")
    String productName;
    @BooleanField(configFieldName="sendScopeClientId", externalizedKeyName="sendScopeClientId", externalized=true, description="A flag to indicate if the scope client id will be sent as a common tag. If it is true, try to retrieve\nit from the audit info and send it if it is not null. If it does not exist, \"unknown\" will be sent.\nBy default, this tag is not sent regardless if it is in the audit info. You only enable this if your\nAPI will be accessed by a Mobile or SPA application with authorization code flow. In this case, the\nprimary token is the authorization code token that contains user info and the secondary scope token\nis the client_credentials token from the immediate caller service in the invocation chain.")
    boolean sendScopeClientId;
    @BooleanField(configFieldName="sendCallerId", externalizedKeyName="sendCallerId", externalized=true, description="A flag to indicate if the caller id will be sent as a common tag. If it is true, try to retrieve it\nfrom the audit info and send it if it is not null. If it doesn't exist, \"unknown\" will be sent.\nBy default, this tag is not sent regardless if it is in the audit info. The purpose of this tag is\nsimilar to the scopeClientId to identify the immediate caller service in a microservice application.\nAs the scopeClientId is only available when the scope token is used, it cannot be used for all apps.\nlight-4j client module has a config to enforce all services to send the callerId to the downstream\nAPI, and it can be enforced within an organization. In most cases, this callerId is more reliable.")
    boolean sendCallerId;
    @BooleanField(configFieldName="sendIssuer", externalizedKeyName="sendIssuer", externalized=true, description="A flag to indicate if the issuer will be sent as a common tag. If it is true, try to retrieve it\nfrom the audit info and send it if it is not null. If it doesn't exist, \"unknown\" will be sent.\nBy default, this tag is not sent regardless if it is in the audit info. This tag should only be\nsent if the organization uses multiple OAuth 2.0 providers. For example, Okta will provide multiple\nvirtual instances, so each service can have its private OAuth 2.0 provider. If all services are\nsharing the same OAuth 2.0 provide (same issuer in the token), this tag should not be used.")
    boolean sendIssuer;
    @StringField(configFieldName="issuerRegex", externalizedKeyName="issuerRegex", externalized=true, description="If issuer is sent, it might be necessary to extract only partial of the string with a regex pattern.\nFor example, Okta iss is something like: \"https://networknt.oktapreview.com/oauth2/aus9xt6dd1cSYyRPH1d6\"\nWe only need to extract the last part after the last slash. The following default regex is just for it.\nThe code in the light-4j is trying to extract the matcher.group(1) and there is a junit test to allow\nusers to test their regex. If you are using Okat, you can set metrics.issuerRegex: /([^/]+)$\nBy default, the regex is empty, and the original iss will be sent as a tag.")
    String issuerRegex;
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();

    private MetricsConfig() {
        this(CONFIG_NAME);
    }

    private MetricsConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    public static MetricsConfig load() {
        return new MetricsConfig();
    }

    public static MetricsConfig load(String configName) {
        return new MetricsConfig(configName);
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnableJVMMonitor() {
        return this.enableJVMMonitor;
    }

    public void setEnableJVMMonitor(boolean enableJVMMonitor) {
        this.enableJVMMonitor = enableJVMMonitor;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public String getServerProtocol() {
        return this.serverProtocol;
    }

    public void setServerProtocol(String serverProtocol) {
        this.serverProtocol = serverProtocol;
    }

    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public int getReportInMinutes() {
        return this.reportInMinutes;
    }

    public void setReportInMinutes(int reportInMinutes) {
        this.reportInMinutes = reportInMinutes;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerUser() {
        return this.serverUser;
    }

    public void setServerUser(String serverUser) {
        this.serverUser = serverUser;
    }

    public String getServerPass() {
        return this.serverPass;
    }

    public void setServerPass(String serverPass) {
        this.serverPass = serverPass;
    }

    public String getServerPath() {
        return this.serverPath;
    }

    public void setServerPath(String serverPath) {
        this.serverPath = serverPath;
    }

    public boolean isSendScopeClientId() {
        return this.sendScopeClientId;
    }

    public void setSendScopeClientId(boolean sendScopeClientId) {
        this.sendScopeClientId = sendScopeClientId;
    }

    public boolean isSendCallerId() {
        return this.sendCallerId;
    }

    public void setSendCallerId(boolean sendCallerId) {
        this.sendCallerId = sendCallerId;
    }

    public boolean isSendIssuer() {
        return this.sendIssuer;
    }

    public void setSendIssuer(boolean sendIssuer) {
        this.sendIssuer = sendIssuer;
    }

    public String getIssuerRegex() {
        return this.issuerRegex;
    }

    public void setIssuerRegex(String issuerRegex) {
        this.issuerRegex = issuerRegex;
    }

    Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    private void setConfigData() {
        Object object = this.getMappedConfig().get(ENABLED);
        if (object != null) {
            this.enabled = Config.loadBooleanValue(ENABLED, object);
        }
        if ((object = this.getMappedConfig().get(ENABLED_JVM_MONITOR)) != null) {
            this.enableJVMMonitor = Config.loadBooleanValue(ENABLED_JVM_MONITOR, object);
        }
        if ((object = this.mappedConfig.get(SERVER_PROTOCOL)) != null) {
            this.setServerProtocol((String)object);
        }
        if ((object = this.mappedConfig.get(SERVER_HOST)) != null) {
            this.serverHost = (String)object;
        }
        if ((object = this.mappedConfig.get(SERVER_PORT)) != null) {
            this.serverPort = Config.loadIntegerValue(SERVER_PORT, object);
        }
        if ((object = this.getMappedConfig().get(SERVER_PATH)) != null) {
            this.serverPath = (String)object;
        }
        if ((object = this.getMappedConfig().get(SERVER_NAME)) != null) {
            this.serverName = (String)object;
        }
        if ((object = this.getMappedConfig().get(SERVER_USER)) != null) {
            this.serverUser = (String)object;
        }
        if ((object = this.getMappedConfig().get(SERVER_PASS)) != null) {
            this.serverPass = (String)object;
        }
        if ((object = this.getMappedConfig().get(REPORT_IN_MINUTES)) != null) {
            this.reportInMinutes = Config.loadIntegerValue(REPORT_IN_MINUTES, object);
        }
        if ((object = this.getMappedConfig().get(PRODUCT_NAME)) != null) {
            this.productName = (String)object;
        }
        if ((object = this.getMappedConfig().get(SEND_SCOPE_CLIENT_ID)) != null) {
            this.sendScopeClientId = Config.loadBooleanValue(SEND_SCOPE_CLIENT_ID, object);
        }
        if ((object = this.getMappedConfig().get(SEND_CALLER_ID)) != null) {
            this.sendCallerId = Config.loadBooleanValue(SEND_CALLER_ID, object);
        }
        if ((object = this.getMappedConfig().get(SEND_ISSUER)) != null) {
            this.sendIssuer = Config.loadBooleanValue(SEND_ISSUER, object);
        }
        if ((object = this.getMappedConfig().get(ISSUER_REGEX)) != null) {
            this.issuerRegex = (String)object;
        }
    }
}

