/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.metrics;

import io.dropwizard.metrics.Gauge;
import io.dropwizard.metrics.Metric;
import io.dropwizard.metrics.MetricName;
import io.dropwizard.metrics.MetricRegistry;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class JVMMetricsUtil {
    public static void trackAllJVMMetrics(MetricRegistry registry, Map<String, String> commonTags) {
        MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
        JVMMetricsUtil.track("mem.heap_mem", memBean.getHeapMemoryUsage(), registry, commonTags);
        JVMMetricsUtil.track("mem.nonheap_mem", memBean.getNonHeapMemoryUsage(), registry, commonTags);
        double hmu = Long.valueOf(memBean.getHeapMemoryUsage().getUsed()).doubleValue();
        double hmc = Long.valueOf(memBean.getHeapMemoryUsage().getMax()).doubleValue();
        if (hmc == -1.0) {
            hmc = Long.valueOf(memBean.getHeapMemoryUsage().getCommitted()).doubleValue();
        }
        double nhmu = Long.valueOf(memBean.getNonHeapMemoryUsage().getUsed()).doubleValue();
        double nhmc = Long.valueOf(memBean.getNonHeapMemoryUsage().getMax()).doubleValue();
        if (nhmc == -1.0) {
            nhmc = Long.valueOf(memBean.getNonHeapMemoryUsage().getCommitted()).doubleValue();
        }
        JVMMetricsUtil.track("mem.heap_usage", hmu / hmc, registry, commonTags);
        JVMMetricsUtil.track("mem.nonheap_usage", nhmu / nhmc, registry, commonTags);
        MBeanServer beans = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName os = new ObjectName("java.lang:type=OperatingSystem");
            Double sysCpuLoad = (Double)beans.getAttribute(os, "SystemCpuLoad");
            Double processCpuLoad = (Double)beans.getAttribute(os, "ProcessCpuLoad");
            double totalPMemory = ((Long)beans.getAttribute(os, "TotalPhysicalMemorySize")).doubleValue();
            double freePMemory = ((Long)beans.getAttribute(os, "FreePhysicalMemorySize")).doubleValue();
            JVMMetricsUtil.track("os.sys_cpu_load", sysCpuLoad, registry, commonTags);
            JVMMetricsUtil.track("os.process_cpu_load", processCpuLoad, registry, commonTags);
            JVMMetricsUtil.track("os.mem_usage", (totalPMemory - freePMemory) / totalPMemory, registry, commonTags);
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            e.printStackTrace();
        }
        JVMMetricsUtil.track("thread.count", ManagementFactory.getThreadMXBean().getThreadCount(), registry, commonTags);
    }

    private static void track(String name2, MemoryUsage m4, MetricRegistry registry, Map<String, String> commonTags) {
        MetricName mName = MetricRegistry.name("jvm", name2).tagged(commonTags);
        registry.remove(mName.resolve("used"));
        registry.getOrAdd(mName.resolve("used"), JVMMetricsUtil.createGaugeMetricBuilder(m4.getUsed()));
        registry.remove(mName.resolve("init"));
        registry.getOrAdd(mName.resolve("init"), JVMMetricsUtil.createGaugeMetricBuilder(m4.getInit()));
        registry.remove(mName.resolve("max"));
        registry.getOrAdd(mName.resolve("max"), JVMMetricsUtil.createGaugeMetricBuilder(m4.getMax()));
        registry.remove(mName.resolve("committed"));
        registry.getOrAdd(mName.resolve("committed"), JVMMetricsUtil.createGaugeMetricBuilder(m4.getCommitted()));
    }

    private static void track(String name2, Long value, MetricRegistry registry, Map<String, String> commonTags) {
        MetricName mName = MetricRegistry.name("jvm", name2).tagged(commonTags);
        registry.remove(mName);
        registry.getOrAdd(mName, JVMMetricsUtil.createGaugeMetricBuilder(value));
    }

    private static void track(String name2, Double value, MetricRegistry registry, Map<String, String> commonTags) {
        MetricName mName = MetricRegistry.name("jvm", name2).tagged(commonTags);
        registry.remove(mName);
        registry.getOrAdd(mName, JVMMetricsUtil.createGaugeMetricBuilder(value));
    }

    private static void track(String name2, int value, MetricRegistry registry, Map<String, String> commonTags) {
        MetricName mName = MetricRegistry.name("jvm", name2).tagged(commonTags);
        registry.remove(mName);
        registry.getOrAdd(mName, JVMMetricsUtil.createGaugeMetricBuilder(value));
    }

    private static MetricRegistry.MetricBuilder<Gauge<Long>> createGaugeMetricBuilder(final long value) {
        return new MetricRegistry.MetricBuilder<Gauge<Long>>(){

            @Override
            public Gauge<Long> newMetric() {
                return () -> value;
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Gauge.class.isInstance(metric);
            }
        };
    }

    private static MetricRegistry.MetricBuilder<Gauge<Double>> createGaugeMetricBuilder(final Double value) {
        return new MetricRegistry.MetricBuilder<Gauge<Double>>(){

            @Override
            public Gauge<Double> newMetric() {
                return () -> value;
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Gauge.class.isInstance(metric);
            }
        };
    }

    private static MetricRegistry.MetricBuilder<Gauge<Integer>> createGaugeMetricBuilder(final int value) {
        return new MetricRegistry.MetricBuilder<Gauge<Integer>>(){

            @Override
            public Gauge<Integer> newMetric() {
                return () -> value;
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Gauge.class.isInstance(metric);
            }
        };
    }
}

