/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.producer;

import java.time.Instant;
import java.util.Objects;
import org.apache.kafka.clients.producer.RecordMetadata;

public class ProduceResult {
    String topic;
    int partitionId;
    long offset;
    Instant timestamp;
    int serializeKeySize;
    int serializeValueSize;

    public ProduceResult() {
    }

    public ProduceResult(int partitionId, long offset, Instant timestamp, int serializeKeySize, int serializeValueSize) {
        this.partitionId = partitionId;
        this.offset = offset;
        this.timestamp = timestamp;
        this.serializeKeySize = serializeKeySize;
        this.serializeValueSize = serializeValueSize;
    }

    public ProduceResult(String topic, int partitionId, long offset, Instant timestamp, int serializeKeySize, int serializeValueSize) {
        this.topic = topic;
        this.partitionId = partitionId;
        this.offset = offset;
        this.timestamp = timestamp;
        this.serializeKeySize = serializeKeySize;
        this.serializeValueSize = serializeValueSize;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(int partitionId) {
        this.partitionId = partitionId;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
    }

    public int getSerializeKeySize() {
        return this.serializeKeySize;
    }

    public void setSerializeKeySize(int serializeKeySize) {
        this.serializeKeySize = serializeKeySize;
    }

    public int getSerializeValueSize() {
        return this.serializeValueSize;
    }

    public void setSerializeValueSize(int serializeValueSize) {
        this.serializeValueSize = serializeValueSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProduceResult that = (ProduceResult)o;
        return this.partitionId == that.partitionId && this.offset == that.offset && this.serializeKeySize == that.serializeKeySize && this.serializeValueSize == that.serializeValueSize && this.timestamp.equals(that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.partitionId, this.offset, this.timestamp, this.serializeKeySize, this.serializeValueSize);
    }

    public static ProduceResult fromRecordMetadata(RecordMetadata metadata) {
        return new ProduceResult(metadata.topic(), metadata.partition(), metadata.offset(), metadata.hasTimestamp() ? Instant.ofEpochMilli(metadata.timestamp()) : null, metadata.serializedKeySize(), metadata.serializedValueSize());
    }
}

