/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.producer;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.ByteString;
import com.networknt.kafka.entity.EmbeddedFormat;
import io.confluent.kafka.serializers.KafkaJsonSerializer;
import io.confluent.kafka.serializers.KafkaJsonSerializerConfig;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;

public class NoSchemaRecordSerializer {
    private final JsonSerializer jsonSerializer;

    public NoSchemaRecordSerializer(Map<String, Object> jsonSerializerConfigs) {
        this.jsonSerializer = new JsonSerializer(jsonSerializerConfigs);
    }

    public Optional<ByteString> serialize(int index, EmbeddedFormat format, JsonNode data) {
        Preconditions.checkArgument(!format.requiresSchema());
        if (data.isNull()) {
            return Optional.empty();
        }
        switch (format) {
            case BINARY: {
                return Optional.of(NoSchemaRecordSerializer.serializeBinary(index, data));
            }
            case JSON: {
                return Optional.of(this.serializeJson(index, data));
            }
            case STRING: {
                return Optional.of(NoSchemaRecordSerializer.serializeString(index, data));
            }
        }
        throw new AssertionError((Object)String.format("Unexpected enum constant: %s", new Object[]{format}));
    }

    private static ByteString serializeBinary(int index, JsonNode data) {
        byte[] serialized;
        if (!data.isTextual()) {
            throw new RuntimeException(String.format("data is not a base64 string at index = %d.", index));
        }
        try {
            serialized = BaseEncoding.base64().decode(data.asText());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(String.format("data is not a valid base64 string at index = %d.", index), e);
        }
        return ByteString.copyFrom(serialized);
    }

    private static ByteString serializeString(int index, JsonNode data) {
        byte[] serialized;
        if (!data.isTextual()) {
            throw new RuntimeException(String.format("data is not a string at index = %d.", index));
        }
        try {
            serialized = data.asText().getBytes(StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(String.format("data is not a valid string at index = %d.", index), e);
        }
        return ByteString.copyFrom(serialized);
    }

    private ByteString serializeJson(int index, JsonNode data) {
        try {
            return ByteString.copyFrom(this.jsonSerializer.serialize(data));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("data is not a valid json at index = %d.", index), e);
        }
    }

    private static final class JsonSerializer
    extends KafkaJsonSerializer<JsonNode> {
        private JsonSerializer(Map<String, Object> configs) {
            this.configure(new KafkaJsonSerializerConfig(configs));
        }

        private byte[] serialize(JsonNode data) {
            return this.serialize("", data);
        }
    }
}

