/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.networknt.kafka.entity.PartitionOffset;
import java.util.List;
import java.util.Objects;

public class ProduceResponse {
    public static final int KAFKA_BAD_REQUEST_ERROR_CODE = 40002;
    public static final int KAFKA_AUTHENTICATION_ERROR_CODE = 40101;
    public static final int KAFKA_AUTHORIZATION_ERROR_CODE = 40301;
    public static final int TOPIC_NOT_FOUND_ERROR_CODE = 40401;
    public static final int PARTITION_NOT_FOUND_ERROR_CODE = 40402;
    public static final int KAFKA_UNKNOWN_TOPIC_PARTITION_CODE = 40403;
    public static final int KAFKA_ERROR_ERROR_CODE = 50002;
    public static final int KAFKA_RETRIABLE_ERROR_ERROR_CODE = 50003;
    public static final int BROKER_NOT_AVAILABLE_ERROR_CODE = 50302;
    List<PartitionOffset> offsets;
    Integer keySchemaId;
    Integer valueSchemaId;

    @JsonCreator
    public ProduceResponse(@JsonProperty(value="offsets") List<PartitionOffset> offsets, @JsonProperty(value="key_schema_id") Integer keySchemaId, @JsonProperty(value="value_schema_id") Integer valueSchemaId) {
        this.offsets = offsets;
        this.keySchemaId = keySchemaId;
        this.valueSchemaId = valueSchemaId;
    }

    @JsonProperty
    public List<PartitionOffset> getOffsets() {
        return this.offsets;
    }

    public void setOffsets(List<PartitionOffset> offsets) {
        this.offsets = offsets;
    }

    @JsonProperty(value="key_schema_id")
    public Integer getKeySchemaId() {
        return this.keySchemaId;
    }

    public void setKeySchemaId(Integer keySchemaId) {
        this.keySchemaId = keySchemaId;
    }

    @JsonProperty(value="value_schema_id")
    public Integer getValueSchemaId() {
        return this.valueSchemaId;
    }

    public void setValueSchemaId(Integer valueSchemaId) {
        this.valueSchemaId = valueSchemaId;
    }

    @JsonIgnore
    public int getStatusCode() {
        for (PartitionOffset partitionOffset : this.offsets) {
            if (partitionOffset.getErrorCode() == null) continue;
            if (partitionOffset.getErrorCode() == 40101) {
                return 401;
            }
            if (partitionOffset.getErrorCode() != 40301) continue;
            return 403;
        }
        return 200;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProduceResponse that = (ProduceResponse)o;
        return Objects.equals(this.offsets, that.offsets) && Objects.equals(this.keySchemaId, that.keySchemaId) && Objects.equals(this.valueSchemaId, that.valueSchemaId);
    }

    public int hashCode() {
        return Objects.hash(this.offsets, this.keySchemaId, this.valueSchemaId);
    }

    public String getRequestStatus() {
        for (PartitionOffset partitionOffset : this.offsets) {
            if (partitionOffset.getErrorCode() == null) continue;
            if (partitionOffset.getErrorCode() == 40101) {
                return "UNAUTHORIZED";
            }
            if (partitionOffset.getErrorCode() != 40301) continue;
            return "FORBIDDEN";
        }
        return "OK";
    }
}

