/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.common.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.networknt.kafka.common.converter.ConversionException;
import com.networknt.kafka.common.converter.SchemaConverter;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AvroConverter
implements SchemaConverter {
    private static final Logger log = LoggerFactory.getLogger(AvroConverter.class);
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    @Override
    public SchemaConverter.JsonNodeAndSize toJson(Object value) {
        try {
            byte[] bytes = AvroSchemaUtils.toJson(value);
            if (bytes == null) {
                return new SchemaConverter.JsonNodeAndSize(NullNode.getInstance(), 0L);
            }
            return new SchemaConverter.JsonNodeAndSize(JSON_MAPPER.readTree(bytes), bytes.length);
        }
        catch (IOException e) {
            log.error("Jackson failed to deserialize JSON generated by Avro's JSON encoder: ", e);
            throw new ConversionException("Failed to convert Avro to JSON: " + e.getMessage());
        }
        catch (RuntimeException e) {
            log.error("Unexpected exception converting Avro to JSON: ", e);
            throw new ConversionException("Failed to convert Avro to JSON: " + e.getMessage());
        }
    }
}

