/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.common;

import java.util.HashSet;
import java.util.Set;

public class TransactionalIdsGenerator {
    private final String prefix;
    private final int subtaskIndex;
    private final int totalNumberOfSubtasks;
    private final int poolSize;
    private final int safeScaleDownFactor;

    public TransactionalIdsGenerator(String prefix, int subtaskIndex, int totalNumberOfSubtasks, int poolSize, int safeScaleDownFactor) {
        this.prefix = prefix;
        this.subtaskIndex = subtaskIndex;
        this.totalNumberOfSubtasks = totalNumberOfSubtasks;
        this.poolSize = poolSize;
        this.safeScaleDownFactor = safeScaleDownFactor;
    }

    public Set<String> generateIdsToUse(long nextFreeTransactionalId) {
        HashSet<String> transactionalIds = new HashSet<String>();
        for (int i = 0; i < this.poolSize; ++i) {
            long transactionalId = nextFreeTransactionalId + (long)(this.subtaskIndex * this.poolSize) + (long)i;
            transactionalIds.add(this.generateTransactionalId(transactionalId));
        }
        return transactionalIds;
    }

    public Set<String> generateIdsToAbort() {
        HashSet<String> idsToAbort = new HashSet<String>();
        for (int i = 0; i < this.safeScaleDownFactor; ++i) {
            idsToAbort.addAll(this.generateIdsToUse(i * this.poolSize * this.totalNumberOfSubtasks));
        }
        return idsToAbort;
    }

    private String generateTransactionalId(long transactionalId) {
        return String.format(this.prefix + "-%d", transactionalId);
    }
}

