/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.common;

import com.networknt.config.Config;
import com.networknt.kafka.common.KafkaConsumerConfig;
import com.networknt.kafka.common.KafkaProducerConfig;
import com.networknt.kafka.common.KafkaStreamsConfig;
import com.networknt.service.SingletonServiceFactory;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.util.HashMap;
import java.util.Map;

public class AbstractAvroSerDe {
    protected static final byte MAGIC_BYTE = 0;
    protected static final int idSize = 4;
    protected SchemaRegistryClient schemaRegistry;
    protected Map<String, Object> config = new HashMap<String, Object>();

    public AbstractAvroSerDe() {
        KafkaConsumerConfig consumerConfig;
        KafkaProducerConfig producerConfig;
        KafkaStreamsConfig streamsConfig = (KafkaStreamsConfig)Config.getInstance().getJsonObjectConfig("kafka-streams", KafkaStreamsConfig.class);
        if (streamsConfig != null) {
            this.config.putAll(streamsConfig.getProperties());
        }
        if (this.config.size() == 0 && (producerConfig = (KafkaProducerConfig)Config.getInstance().getJsonObjectConfig("kafka-producer", KafkaProducerConfig.class)) != null) {
            this.config.putAll(producerConfig.getProperties());
        }
        if (this.config.size() == 0 && (consumerConfig = (KafkaConsumerConfig)Config.getInstance().getJsonObjectConfig("kafka-consumer", KafkaConsumerConfig.class)) != null) {
            this.config.putAll(consumerConfig.getProperties());
        }
        this.schemaRegistry = SingletonServiceFactory.getBean(SchemaRegistryClient.class);
    }
}

