/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.common;

import com.networknt.kafka.common.AbstractAvroSerDe;
import com.networknt.kafka.common.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecord;
import org.apache.kafka.common.errors.SerializationException;

public abstract class AbstractAvroDeserializer
extends AbstractAvroSerDe {
    private final DecoderFactory decoderFactory = DecoderFactory.get();
    protected boolean useSpecificAvroReader = false;
    private final Map<String, Schema> readerSchemaCache = new ConcurrentHashMap<String, Schema>();

    private ByteBuffer getByteBuffer(byte[] payload) {
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        if (buffer.get() != 0) {
            throw new RuntimeException("Unknown magic byte!");
        }
        return buffer;
    }

    public Object deserialize(byte[] payload) throws SerializationException {
        return this.deserialize(false, null, null, payload, null);
    }

    public Object deserialize(byte[] payload, Schema readerSchema) throws SerializationException {
        return this.deserialize(false, null, null, payload, readerSchema);
    }

    protected Object deserialize(boolean includeSchemaAndVersion, String topic, Boolean isKey, byte[] payload, Schema readerSchema) throws SerializationException {
        if (payload == null) {
            return null;
        }
        int id = -1;
        try {
            Object result2;
            ByteBuffer buffer = this.getByteBuffer(payload);
            id = buffer.getInt();
            Schema schema = this.schemaRegistry.getById(id);
            int length = buffer.limit() - 1 - 4;
            if (schema.getType().equals((Object)Schema.Type.BYTES)) {
                byte[] bytes = new byte[length];
                buffer.get(bytes, 0, length);
                result2 = bytes;
            } else {
                int start = buffer.position() + buffer.arrayOffset();
                DatumReader reader = this.getDatumReader(schema, readerSchema);
                Object object = reader.read(null, this.decoderFactory.binaryDecoder(buffer.array(), start, length, null));
                if (schema.getType().equals((Object)Schema.Type.STRING)) {
                    object = object.toString();
                }
                result2 = object;
            }
            return result2;
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException("Error deserializing Avro message for id " + id, e);
        }
        catch (RestClientException e) {
            throw new SerializationException("Error retrieving Avro schema for id " + id, e);
        }
    }

    private DatumReader getDatumReader(Schema writerSchema, Schema readerSchema) {
        boolean writerSchemaIsPrimitive = AvroSchemaUtils.getPrimitiveSchemas().values().contains(writerSchema);
        if (this.useSpecificAvroReader && !writerSchemaIsPrimitive) {
            if (readerSchema == null) {
                readerSchema = this.getReaderSchema(writerSchema);
            }
            return new SpecificDatumReader(writerSchema, readerSchema);
        }
        if (readerSchema == null) {
            return new GenericDatumReader(writerSchema);
        }
        return new GenericDatumReader(writerSchema, readerSchema);
    }

    private Schema getReaderSchema(Schema writerSchema) {
        Schema readerSchema = this.readerSchemaCache.get(writerSchema.getFullName());
        if (readerSchema == null) {
            Class readerClass = SpecificData.get().getClass(writerSchema);
            if (readerClass != null) {
                try {
                    readerSchema = ((SpecificRecord)readerClass.newInstance()).getSchema();
                }
                catch (InstantiationException e) {
                    throw new SerializationException(writerSchema.getFullName() + " specified by the writers schema could not be instantiated to find the readers schema.");
                }
                catch (IllegalAccessException e) {
                    throw new SerializationException(writerSchema.getFullName() + " specified by the writers schema is not allowed to be instantiated to find the readers schema.");
                }
                this.readerSchemaCache.put(writerSchema.getFullName(), readerSchema);
            } else {
                throw new SerializationException("Could not find class " + writerSchema.getFullName() + " specified in writer's schema whilst finding reader's schema for a SpecificRecord.");
            }
        }
        return readerSchema;
    }
}

