/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.info;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import com.networknt.config.schema.ArrayField;
import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.ConfigSchema;
import com.networknt.config.schema.OutputFormat;
import com.networknt.config.schema.StringField;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigSchema(configName="info", configKey="info", outputFormats={OutputFormat.JSON_SCHEMA, OutputFormat.YAML})
public class ServerInfoConfig {
    private static final Logger logger = LoggerFactory.getLogger(ServerInfoConfig.class);
    public static final String CONFIG_NAME = "info";
    public static final String ENABLE_SERVER_INFO = "enableServerInfo";
    public static final String KEYS_TO_NOT_SORT = "keysToNotSort";
    private static final String DOWNSTREAM_ENABLED = "downstreamEnabled";
    private static final String DOWNSTREAM_HOST = "downstreamHost";
    private static final String DOWNSTREAM_PATH = "downstreamPath";
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();
    @BooleanField(configFieldName="enableServerInfo", externalizedKeyName="enableServerInfo", externalized=true, defaultValue=true, description="Indicate if the server info is enabled or not.")
    boolean enableServerInfo;
    @ArrayField(configFieldName="keysToNotSort", externalizedKeyName="keysToNotSort", externalized=true, defaultValue="[\"admin\", \"default\", \"defaultHandlers\", \"request\", \"response\"]", description="String list keys that should not be sorted in the normalized info output. If you have a list of string values\ndefine in one of your config files and the sequence of the values is important, you can add the key to this list.\nIf you want to add your own keys, please make sure that you include the following default keys in your values.yml", items=String.class)
    List<String> keysToNotSort;
    @BooleanField(configFieldName="downstreamEnabled", externalizedKeyName="downstreamEnabled", externalized=true, description="For some of the services like light-gateway, http-sidecar and kafka-sidecar, we might need to check the down\nstream API before return the server info to the invoker. By default, it is not enabled.\nif the server info needs to invoke down streams API. It is false by default.")
    boolean downstreamEnabled;
    @StringField(configFieldName="downstreamHost", externalizedKeyName="downstreamHost", externalized=true, defaultValue="http://localhost:8081", description="down stream API host. http://localhost is the default when used with http-sidecar and kafka-sidecar.")
    String downstreamHost;
    @StringField(configFieldName="downstreamPath", externalizedKeyName="downstreamPath", externalized=true, defaultValue="/adm/server/info", description="down stream API server info path. This allows the down stream API to have customized path implemented.")
    String downstreamPath;

    private ServerInfoConfig() {
        this(CONFIG_NAME);
    }

    private ServerInfoConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setData();
        this.setList();
    }

    public static ServerInfoConfig load() {
        return new ServerInfoConfig();
    }

    public static ServerInfoConfig load(String configName) {
        return new ServerInfoConfig(configName);
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setData();
        this.setList();
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public Config getConfig() {
        return this.config;
    }

    public List<String> getKeysToNotSort() {
        return this.keysToNotSort;
    }

    public boolean isEnableServerInfo() {
        return this.enableServerInfo;
    }

    public void setEnableServerInfo(boolean enableServerInfo) {
        this.enableServerInfo = enableServerInfo;
    }

    public boolean isDownstreamEnabled() {
        return this.downstreamEnabled;
    }

    public void setDownstreamEnabled(boolean downstreamEnabled) {
        this.downstreamEnabled = downstreamEnabled;
    }

    public String getDownstreamHost() {
        return this.downstreamHost;
    }

    public void setDownstreamHost(String downstreamHost) {
        this.downstreamHost = downstreamHost;
    }

    public String getDownstreamPath() {
        return this.downstreamPath;
    }

    public void setDownstreamPath(String downstreamPath) {
        this.downstreamPath = downstreamPath;
    }

    private void setData() {
        Object object = this.mappedConfig.get(ENABLE_SERVER_INFO);
        if (object != null) {
            this.enableServerInfo = Config.loadBooleanValue(ENABLE_SERVER_INFO, object);
        }
        if ((object = this.getMappedConfig().get(DOWNSTREAM_ENABLED)) != null) {
            this.downstreamEnabled = Config.loadBooleanValue(DOWNSTREAM_ENABLED, object);
        }
        if ((object = this.getMappedConfig().get(DOWNSTREAM_HOST)) != null) {
            this.downstreamHost = (String)object;
        }
        if ((object = this.getMappedConfig().get(DOWNSTREAM_PATH)) != null) {
            this.downstreamPath = (String)object;
        }
    }

    private void setList() {
        if (this.mappedConfig.get(KEYS_TO_NOT_SORT) instanceof String) {
            String s2 = (String)this.mappedConfig.get(KEYS_TO_NOT_SORT);
            s2 = s2.trim();
            if (logger.isTraceEnabled()) {
                logger.trace("s = " + s2);
            }
            if (s2.startsWith("[")) {
                try {
                    this.keysToNotSort = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                }
                catch (Exception e) {
                    throw new ConfigException("could not parse the keysToNotSort json with a list of strings.");
                }
            } else {
                this.keysToNotSort = Arrays.asList(s2.split("\\s*,\\s*"));
            }
        } else {
            this.keysToNotSort = this.getMappedConfig().get(KEYS_TO_NOT_SORT) instanceof List ? (List<Object>)this.mappedConfig.get(KEYS_TO_NOT_SORT) : Arrays.asList("admin", "default", "defaultHandlers");
        }
    }
}

