/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.http;

import com.networknt.http.HttpEntity;
import com.networknt.http.HttpStatus;
import com.networknt.http.MediaType;
import com.networknt.utility.ObjectUtils;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;

public class ResponseEntity<T>
extends HttpEntity<T> {
    private final Object status;

    public ResponseEntity(HttpStatus status) {
        this(null, null, status);
    }

    public ResponseEntity(T body, HttpStatus status) {
        this(body, null, status);
    }

    public ResponseEntity(HeaderMap headers, HttpStatus status) {
        this(null, headers, status);
    }

    public ResponseEntity(T body, HeaderMap headers, HttpStatus status) {
        this(body, headers, (Object)status);
    }

    public ResponseEntity(T body, HeaderMap headers, int rawStatus) {
        this(body, headers, (Object)rawStatus);
    }

    private ResponseEntity(T body, HeaderMap headers, Object status) {
        super(body, headers);
        this.status = status;
    }

    public HttpStatus getStatusCode() {
        if (this.status instanceof HttpStatus) {
            return (HttpStatus)((Object)this.status);
        }
        return HttpStatus.valueOf((Integer)this.status);
    }

    public int getStatusCodeValue() {
        if (this.status instanceof HttpStatus) {
            return ((HttpStatus)((Object)this.status)).value();
        }
        return (Integer)this.status;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        ResponseEntity otherEntity = (ResponseEntity)other;
        return ObjectUtils.nullSafeEquals(this.status, otherEntity.status);
    }

    @Override
    public int hashCode() {
        return 29 * super.hashCode() + ObjectUtils.nullSafeHashCode(this.status);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("<");
        builder.append(this.status.toString());
        if (this.status instanceof HttpStatus) {
            builder.append(' ');
            builder.append(((HttpStatus)((Object)this.status)).getReasonPhrase());
        }
        builder.append(',');
        Object body = this.getBody();
        HeaderMap headers = this.getHeaders();
        if (body != null) {
            builder.append(body);
            builder.append(',');
        }
        builder.append(headers);
        builder.append('>');
        return builder.toString();
    }

    public static BodyBuilder status(HttpStatus status) {
        return new DefaultBuilder((Object)status);
    }

    public static BodyBuilder status(int status) {
        return new DefaultBuilder(status);
    }

    public static BodyBuilder ok() {
        return ResponseEntity.status(HttpStatus.OK);
    }

    public static <T> ResponseEntity<T> ok(T body) {
        return ResponseEntity.ok().body(body);
    }

    public static BodyBuilder accepted() {
        return ResponseEntity.status(HttpStatus.ACCEPTED);
    }

    public static BodyBuilder badRequest() {
        return ResponseEntity.status(HttpStatus.BAD_REQUEST);
    }

    public static BodyBuilder unprocessableEntity() {
        return ResponseEntity.status(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    private static class DefaultBuilder
    implements BodyBuilder {
        private final Object statusCode;
        private final HeaderMap headers;

        public DefaultBuilder(Object statusCode) {
            this(statusCode, new HeaderMap());
        }

        public DefaultBuilder(Object statusCode, HeaderMap headers) {
            this.statusCode = statusCode;
            this.headers = headers;
        }

        @Override
        public BodyBuilder contentType(MediaType contentType) {
            if (contentType != null) {
                this.headers.put(Headers.CONTENT_TYPE, contentType.toString());
            } else {
                this.headers.remove(Headers.CONTENT_TYPE);
            }
            return this;
        }

        @Override
        public <T> ResponseEntity<T> body(T body) {
            return new ResponseEntity<T>(body, this.headers, this.statusCode);
        }
    }

    public static interface BodyBuilder {
        public BodyBuilder contentType(MediaType var1);

        public <T> ResponseEntity<T> body(T var1);
    }
}

